/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.util.Map;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.AbstractShellInteraction;
import org.jboss.forge.addon.shell.aesh.CommandAdapter;
import org.jboss.forge.addon.shell.aesh.CommandLineUtil;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.output.UIOutput;

public class ShellSingleCommand
extends AbstractShellInteraction {
    private final CommandController controller;
    private CommandLineParser<?> commandLineParser;

    public ShellSingleCommand(CommandController controller, ShellContext shellContext, CommandLineUtil commandLineUtil) {
        super(controller, shellContext, commandLineUtil);
        this.controller = controller;
    }

    @Override
    public CommandLineParser<?> getParser(ShellContext shellContext, String completeLine, CommandAdapter command) throws Exception {
        if (this.commandLineParser == null) {
            this.controller.initialize();
            this.commandLineParser = this.commandLineUtil.generateParser(command, this.controller, shellContext, this.controller.getInputs());
        }
        return this.commandLineParser;
    }

    @Override
    public boolean promptRequiredMissingValues(ShellImpl shell) throws InterruptedException {
        Map inputs = this.getController().getInputs();
        if (this.hasMissingRequiredInputValues(inputs.values())) {
            UIOutput output = shell.getOutput();
            if (!this.getContext().isInteractive()) {
                output.error(output.out(), "Required inputs not satisfied and INTERACTIVE=false, aborting. Please 'export INTERACTIVE=true' or try again providing the required values.");
                return false;
            }
            output.info(output.out(), "Required inputs not satisfied, entering interactive mode");
            this.promptRequiredMissingValues(shell, inputs.values());
        }
        return true;
    }
}

