/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.aesh;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.forge.addon.shell.ShellImpl;
import org.jboss.forge.addon.shell.aesh.AbstractShellInteraction;
import org.jboss.forge.addon.shell.aesh.CommandAdapter;
import org.jboss.forge.addon.shell.aesh.CommandLineUtil;
import org.jboss.forge.addon.shell.aesh.ForgeCommandRegistry;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.controller.CommandController;
import org.jboss.forge.addon.ui.controller.WizardCommandController;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.output.UIOutput;

public class ShellWizard
extends AbstractShellInteraction {
    public ShellWizard(WizardCommandController wizardCommandController, ShellContext shellContext, CommandLineUtil commandLineUtil, ForgeCommandRegistry forgeCommandRegistry) {
        super((CommandController)wizardCommandController, shellContext, commandLineUtil);
    }

    public WizardCommandController getController() {
        return (WizardCommandController)super.getController();
    }

    @Override
    public CommandLineParser<?> getParser(ShellContext shellContext, String completeLine, CommandAdapter commandAdapter) throws Exception {
        this.getController().initialize();
        return this.populate(commandAdapter, shellContext, completeLine, new LinkedHashMap(), new LinkedHashMap());
    }

    private CommandLineParser<?> populate(CommandAdapter commandAdapter, ShellContext shellContext, String line, Map<String, InputComponent<?, ?>> allInputs, Map<String, InputComponent<?, ?>> lastPage) throws Exception {
        WizardCommandController controller = this.getController();
        LinkedHashMap pageInputs = new LinkedHashMap(controller.getInputs());
        allInputs.putAll(pageInputs);
        CommandLineParser<?> parser = this.commandLineUtil.generateParser(commandAdapter, (CommandController)controller, shellContext, allInputs);
        CommandLine cmdLine = parser.parse(line, true);
        Map<String, InputComponent<?, ?>> populatedInputs = this.commandLineUtil.populateUIInputs(cmdLine, allInputs, (UIContext)shellContext);
        parser = this.commandLineUtil.generateParser(commandAdapter, (CommandController)controller, shellContext, allInputs);
        cmdLine = parser.parse(line, true);
        populatedInputs = this.commandLineUtil.populateUIInputs(cmdLine, allInputs, (UIContext)shellContext);
        boolean inputsChanged = false;
        for (String input : pageInputs.keySet()) {
            if (!populatedInputs.containsKey(input)) continue;
            lastPage.keySet().removeAll(populatedInputs.keySet());
            allInputs.keySet().removeAll(lastPage.keySet());
            inputsChanged = true;
            break;
        }
        if (controller.canMoveToNextStep()) {
            controller.next().initialize();
            parser = this.populate(commandAdapter, shellContext, line, allInputs, pageInputs);
        } else if (inputsChanged) {
            parser = this.commandLineUtil.generateParser(commandAdapter, (CommandController)controller, shellContext, allInputs);
        }
        return parser;
    }

    @Override
    public boolean promptRequiredMissingValues(ShellImpl shell) throws InterruptedException {
        WizardCommandController controller = this.getController();
        boolean interactiveModeEnabled = false;
        UIOutput output = shell.getOutput();
        if (this.hasMissingRequiredInputValues(controller.getInputs().values())) {
            if (!this.getContext().isInteractive()) {
                output.error(output.err(), "Required inputs not satisfied and INTERACTIVE=false, aborting. Please 'export INTERACTIVE=true' or try again providing the required values.");
                return false;
            }
            output.info(output.out(), "Required inputs not satisfied, entering interactive mode");
            interactiveModeEnabled = true;
            this.promptRequiredMissingValues(shell, controller.getInputs().values());
        }
        while (controller.canMoveToNextStep()) {
            try {
                controller.next().initialize();
            }
            catch (Exception e) {
                break;
            }
            if (!this.hasMissingRequiredInputValues(controller.getInputs().values())) continue;
            if (!interactiveModeEnabled) {
                if (!this.getContext().isInteractive()) {
                    output.error(output.out(), "Required inputs not satisfied and INTERACTIVE=false, aborting. Please 'export INTERACTIVE=true' or try again providing the required values.");
                    return false;
                }
                output.info(output.out(), "Required inputs not satisfied, entering interactive mode");
                interactiveModeEnabled = true;
            }
            this.promptRequiredMissingValues(shell, controller.getInputs().values());
        }
        return true;
    }
}

