/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.UIDesktop;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class EditCommand
extends AbstractShellCommand {
    @Inject
    @WithAttributes(label="Arguments", type="org.jboss.forge.inputType.FILE_PICKER")
    private UIInputMany<String> arguments;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments);
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("edit").description("Edit files with the default system editor");
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Failed result;
        Iterator it;
        Resource currentResource = (Resource)context.getUIContext().getInitialSelection().get();
        Iterable value = this.arguments.getValue();
        Iterator iterator = it = value == null ? Collections.emptyIterator() : value.iterator();
        if (it.hasNext()) {
            String newPath = (String)it.next();
            List newResource = currentResource.resolveChildren(newPath);
            if (newResource.isEmpty() || !((Resource)newResource.get(0)).exists()) {
                result = Results.fail((String)(newPath + ": No such file or directory"));
            } else {
                for (Resource resource : newResource) {
                    this.editResource(context, resource);
                }
                result = Results.success();
            }
        } else if (currentResource != null) {
            this.editResource(context, currentResource);
            result = Results.success();
        } else {
            result = Results.fail((String)"Resource not found");
        }
        return result;
    }

    private void editResource(UIExecutionContext context, Resource<?> resource) throws IOException {
        UIDesktop desktop = context.getUIContext().getProvider().getDesktop();
        FileResource fileResource = (FileResource)resource.reify(FileResource.class);
        if (fileResource != null && !fileResource.isDirectory()) {
            desktop.edit((File)fileResource.getUnderlyingResourceObject());
        } else {
            UIOutput output = context.getUIContext().getProvider().getOutput();
            output.warn(output.err(), "Cannot edit [" + resource.getFullyQualifiedName() + "].");
        }
    }
}

