/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.shell.ui.AbstractShellCommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class RmCommand
extends AbstractShellCommand {
    @Inject
    @WithAttributes(label="Arguments", type="org.jboss.forge.inputType.FILE_PICKER", required=true)
    private UIInputMany<String> arguments;
    @Inject
    @WithAttributes(label="force", shortName=102, description="ignore nonexistent files and arguments, never prompt", type="org.jboss.forge.inputType.CHECKBOX", defaultValue="false")
    private UIInput<Boolean> force;
    @Inject
    @WithAttributes(label="recursive", shortName=114, description="remove directories and their contents recursively", type="org.jboss.forge.inputType.CHECKBOX", defaultValue="false")
    private UIInput<Boolean> recursive;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("rm").description("Remove (unlink) the FILE(s).");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.arguments).add(this.force).add(this.recursive);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Resource currentResource = (Resource)context.getUIContext().getInitialSelection().get();
        for (String file : this.arguments.getValue()) {
            List resources = currentResource.resolveChildren(file);
            for (Resource resource : resources) {
                if (resource.exists()) continue;
                return Results.fail((String)(file + ": no such file or directory"));
            }
        }
        boolean forceOption = (Boolean)this.force.getValue();
        boolean recurse = (Boolean)this.recursive.getValue();
        UIPrompt prompt = context.getPrompt();
        UIOutput output = context.getUIContext().getProvider().getOutput();
        for (String file : this.arguments.getValue()) {
            List resources = currentResource.resolveChildren(file);
            for (Resource resource : resources) {
                if (resource instanceof DirectoryResource) {
                    if (!recurse) {
                        output.err().println("rm: cannot remove '" + resource.getName() + "': Is a directory ");
                        continue;
                    }
                    if (!resource.listResources().isEmpty() && !forceOption) {
                        output.err().println("rm: directory '" + resource.getName() + "' not empty and cannot be deleted without '--force' '-f' option.");
                        continue;
                    }
                    if (!forceOption && !prompt.promptBoolean("Delete '" + resource.getFullyQualifiedName() + "'?") || resource.delete(recurse)) continue;
                    output.err().println("rm: cannot remove \u2018" + resource.getFullyQualifiedName() + "\u2019: Error occurred during deletion");
                    continue;
                }
                if (resource.delete(recurse)) continue;
                output.err().println("rm: cannot remove \u2018" + resource.getFullyQualifiedName() + "\u2019: Error occurred during deletion");
            }
        }
        while (!currentResource.exists()) {
            currentResource = currentResource.getParent();
        }
        context.getUIContext().setSelection((Object)currentResource);
        return Results.success();
    }
}

