/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.command;

import java.io.IOException;
import org.jboss.forge.addon.ui.annotation.Command;
import org.jboss.forge.addon.ui.annotation.Option;
import org.jboss.forge.addon.ui.annotation.predicate.NonGUIEnabledPredicate;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.furnace.util.Strings;

public class SystemPropertiesCommand {
    @Command(value="system-property-get", help="Get one or all system properties", enabled={NonGUIEnabledPredicate.class})
    public void getSystemProperty(@Option(value="named", description="The property name") String propertyName, UIOutput output) throws IOException {
        if (!Strings.isNullOrEmpty((String)propertyName)) {
            output.out().println(System.getProperty(propertyName));
        } else {
            System.getProperties().store(output.out(), null);
        }
    }

    @Command(value="system-property-set", help="Set a system property", enabled={NonGUIEnabledPredicate.class})
    public String setSystemProperty(@Option(value="named", description="The property name", required=true) String propertyName, @Option(value="value", description="The property value", required=true) String propertyValue) {
        return System.setProperty(propertyName, propertyValue);
    }
}

