/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.ui;

import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.aesh.line.CommandLineImpl;
import org.jboss.forge.addon.shell.line.CommandLine;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.context.AbstractUIContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextListener;
import org.jboss.forge.addon.ui.context.UISelection;

public class ShellContextImpl
extends AbstractUIContext
implements ShellContext {
    private final Shell shell;
    private final UISelection<?> initialSelection;
    private final Iterable<UIContextListener> listeners;

    public ShellContextImpl(Shell shell, UISelection<?> initialSelection, Iterable<UIContextListener> listeners) {
        this.shell = shell;
        this.initialSelection = initialSelection;
        this.listeners = listeners;
        for (UIContextListener listener : listeners) {
            listener.contextInitialized((UIContext)this);
        }
    }

    public UISelection<?> getInitialSelection() {
        return this.initialSelection;
    }

    public Shell getProvider() {
        return this.shell;
    }

    public void close() {
        super.close();
        for (UIContextListener listener : this.listeners) {
            listener.contextDestroyed((UIContext)this);
        }
    }

    public boolean isInteractive() {
        String sysProp = System.getProperty("INTERACTIVE");
        if (sysProp != null) {
            return Boolean.parseBoolean(sysProp);
        }
        Object interactiveFlag = this.getAttributeMap().get("INTERACTIVE");
        return interactiveFlag == null || "true".equalsIgnoreCase(interactiveFlag.toString());
    }

    public boolean isVerbose() {
        Object verboseFlag = this.getAttributeMap().get("VERBOSE");
        return verboseFlag != null && "true".equalsIgnoreCase(verboseFlag.toString());
    }

    public CommandLine getCommandLine() {
        org.jboss.aesh.cl.CommandLine cmdLine = (org.jboss.aesh.cl.CommandLine)this.getAttributeMap().get(org.jboss.aesh.cl.CommandLine.class);
        return new CommandLineImpl(cmdLine);
    }
}

