/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.ui;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.aesh.console.AeshConsole;
import org.jboss.aesh.console.Buffer;
import org.jboss.aesh.console.command.CommandOperation;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.jboss.aesh.terminal.CharacterType;
import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.aesh.terminal.TerminalTextStyle;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.ManyValued;
import org.jboss.forge.addon.ui.input.SelectComponent;
import org.jboss.forge.addon.ui.input.SingleValued;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.util.InputComponents;
import org.jboss.forge.furnace.util.Lists;
import org.jboss.forge.furnace.util.Strings;

public class ShellUIPromptImpl
implements UIPrompt {
    private final ShellContext context;
    private final AeshConsole console;
    private final ConverterFactory converterFactory;
    private final CommandInvocation commandInvocation;

    public ShellUIPromptImpl(ShellContext context, ConverterFactory converterFactory) {
        this.context = context;
        this.converterFactory = converterFactory;
        this.console = context.getProvider().getConsole();
        this.commandInvocation = (CommandInvocation)context.getAttributeMap().get(CommandInvocation.class);
    }

    public String prompt(String message) {
        try {
            return this.promptInternal(message, true, false);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public String promptSecret(String message) {
        try {
            return this.promptInternal(message, false, false);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public boolean promptBoolean(String message) {
        return this.promptBoolean(message, true);
    }

    public boolean promptBoolean(String message, boolean defaultValue) {
        try {
            return this.promptBooleanInternal(message, defaultValue);
        }
        catch (InterruptedException e) {
            return defaultValue;
        }
    }

    public Object promptValueFrom(InputComponent<?, ?> input) throws InterruptedException {
        ArrayList<Object> value = null;
        if (input instanceof SingleValued) {
            if (input instanceof SelectComponent) {
                SelectComponent select = (SelectComponent)input;
                value = this.promptSelectComponent(select, Collections.singleton(select.getValue()));
            } else {
                value = this.promptInputComponent(input, input.getValue());
            }
        } else if (input instanceof ManyValued) {
            Object promptValue;
            ArrayList<Object> inputValues = new ArrayList<Object>();
            Iterable currentValues = ((ManyValued)input).getValue();
            if (currentValues != null) {
                inputValues.addAll(Lists.toList((Iterable)currentValues));
            }
            do {
                if (input instanceof SelectComponent) {
                    SelectComponent select = (SelectComponent)input;
                    promptValue = this.promptSelectComponent(select, inputValues);
                } else {
                    promptValue = this.promptInputComponent(input, inputValues);
                }
                if (promptValue == null) continue;
                if (inputValues.contains(promptValue)) {
                    inputValues.remove(promptValue);
                    continue;
                }
                inputValues.add(promptValue);
            } while (promptValue != null);
            if (!inputValues.isEmpty()) {
                value = inputValues;
            }
        }
        if (value != null) {
            InputComponents.setValueFor((ConverterFactory)this.converterFactory, input, (Object)value);
        }
        return input.getValue();
    }

    private String promptInternal(String message, boolean echo, boolean required) throws InterruptedException {
        PrintStream out = this.console.getShell().out();
        String indicator = required ? "*" : "?";
        String promptFlag = new TerminalString(indicator, new TerminalColor(Color.BLUE, Color.DEFAULT), new TerminalTextStyle(CharacterType.BOLD)).toString();
        out.print(promptFlag + " " + message + " ");
        String output = this.isAcceptDefaultsEnabled() ? null : this.readInput(out, echo);
        out.println();
        return output;
    }

    private boolean promptBooleanInternal(String message, boolean defaultValue) throws InterruptedException {
        String suffix = defaultValue ? " [Y/n]:" : " [y/N]:";
        String answer = this.promptInternal(message + suffix, true, false);
        if (Strings.isNullOrEmpty((String)answer)) {
            return defaultValue;
        }
        if (defaultValue) {
            return !"N".equalsIgnoreCase(answer);
        }
        return "Y".equalsIgnoreCase(answer);
    }

    private Object promptInputComponent(InputComponent<?, ?> input, Object componentValue) throws InterruptedException {
        Object value;
        String label = InputComponents.getLabelFor(input, (boolean)false);
        Object description = input.getDescription();
        description = !Strings.isNullOrEmpty((String)description) ? " (" + (String)description + ")" : "";
        Object defaultValueDescription = componentValue instanceof Collection ? " " + componentValue.toString() : (componentValue != null ? " [" + componentValue + "]" : "");
        String inputType = InputComponents.getInputType(input);
        if ("org.jboss.forge.inputType.SECRET".equals(inputType)) {
            value = this.promptInternal(label + (String)description + (String)defaultValueDescription + ": ", false, input.isRequired());
        } else if (input.getValueType() == Boolean.class) {
            Boolean defaultValue = (Boolean)input.getValue();
            value = this.promptBooleanInternal(label + (String)description, defaultValue == null || defaultValue != false);
        } else {
            value = this.promptInternal(label + (String)description + (String)defaultValueDescription + ": ", true, input.isRequired());
        }
        return value;
    }

    private Object promptSelectComponent(SelectComponent select, Collection<Object> existingItems) throws InterruptedException {
        if (this.isAcceptDefaultsEnabled()) {
            return select.hasDefaultValue() ? select.getValue() : null;
        }
        PrintStream out = this.console.getShell().out();
        String label = InputComponents.getLabelFor((InputComponent)select, (boolean)false);
        Object description = select.getDescription();
        description = !Strings.isNullOrEmpty((String)description) ? " (" + (String)description + "):" : ":";
        Object value = null;
        Converter itemLabelConverter = InputComponents.getItemLabelConverter((ConverterFactory)this.converterFactory, (SelectComponent)select);
        List items = Lists.toList((Iterable)select.getValueChoices());
        if (items.size() > 0) {
            int idx;
            out.println();
            for (int i = 0; i < items.size(); ++i) {
                Object item = items.get(i);
                String itemLabel = (String)itemLabelConverter.convert(item);
                String separator = existingItems.contains(item) ? "(x)" : "( )";
                out.printf("[%s] %s %s", i, separator, itemLabel);
                out.println();
            }
            out.println();
            try {
                out.println("Press <ENTER> to confirm, or <CTRL>+C to cancel.");
                String limit = items.size() == 1 ? "" : "-" + (items.size() - 1);
                String message = label + (String)description + " [0" + limit + "]";
                idx = Integer.parseInt(this.promptInternal(message, true, select.isRequired()));
            }
            catch (NumberFormatException nfe) {
                idx = -1;
            }
            if (idx > -1 && idx < items.size()) {
                value = items.get(idx);
            }
        }
        return value;
    }

    private String readInput(PrintStream out, boolean echo) throws InterruptedException {
        Key inputKey;
        StringBuilder sb = new StringBuilder();
        do {
            CommandOperation input;
            if ((inputKey = (input = this.commandInvocation.getInput()).getInputKey()) == Key.CTRL_C || inputKey == Key.CTRL_D) {
                throw new InterruptedException(inputKey.name());
            }
            if (inputKey == Key.BACKSPACE && sb.length() > 0) {
                sb.setLength(sb.length() - 1);
                if (!echo) continue;
                out.print(Buffer.printAnsi((String)"1D"));
                out.flush();
                out.print(" ");
                out.print(Buffer.printAnsi((String)"1D"));
                out.flush();
                continue;
            }
            if (!inputKey.isPrintable()) continue;
            if (echo) {
                out.print(inputKey.getAsChar());
            }
            sb.append(inputKey.getAsChar());
        } while (inputKey != Key.ENTER && inputKey != Key.ENTER_2);
        return sb.length() == 0 ? null : sb.toString();
    }

    private boolean isAcceptDefaultsEnabled() {
        if (!this.context.isInteractive()) {
            return true;
        }
        Object acceptDefaultsFlag = this.context.getAttributeMap().get("ACCEPT_DEFAULTS");
        return acceptDefaultsFlag != null && "true".equalsIgnoreCase(acceptDefaultsFlag.toString());
    }
}

