/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.ui;

import java.io.PrintStream;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.command.AbstractCommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.result.Failed;
import org.jboss.forge.addon.ui.result.Result;

public class VerboseExecutionListener
extends AbstractCommandExecutionListener {
    public void postCommandExecuted(UICommand command, UIExecutionContext context, Result result) {
        if (result instanceof Failed) {
            this.postCommandFailure(command, context, ((Failed)result).getException());
        }
    }

    public void postCommandFailure(UICommand command, UIExecutionContext context, Throwable failure) {
        UIContext uiContext;
        if (failure != null && (uiContext = context.getUIContext()) instanceof ShellContext) {
            ShellContext shellContext = (ShellContext)uiContext;
            UIOutput output = shellContext.getProvider().getOutput();
            PrintStream err = output.err();
            UICommandMetadata metadata = command.getMetadata((UIContext)shellContext);
            if (metadata != null) {
                output.error(err, "Error while executing '" + metadata.getName() + "'");
            }
            if (shellContext.isVerbose()) {
                failure.printStackTrace(err);
            } else {
                output.info(err, "(type \"export VERBOSE=true\" to enable stack traces)");
            }
        }
    }
}

