/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.util;

import org.jboss.aesh.terminal.Color;
import org.jboss.aesh.terminal.TerminalColor;
import org.jboss.aesh.terminal.TerminalString;
import org.jboss.forge.addon.parser.java.resources.JavaFieldResource;
import org.jboss.forge.addon.parser.java.resources.JavaMethodResource;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.util.Commands;

public class ShellUtil {
    public static String shellifyCommandName(String name) {
        return Commands.shellifyCommandName((String)name);
    }

    public static String shellifyOptionName(String name) {
        return Commands.shellifyOptionName((String)name);
    }

    public static String shellifyOptionNameDashed(String name) {
        return Commands.shellifyOptionNameDashed((String)name);
    }

    public static String colorizeResource(FileResource<?> resource) {
        String name = resource.getName();
        if (resource.isDirectory()) {
            name = new TerminalString(name, new TerminalColor(Color.BLUE, Color.DEFAULT)).toString();
        } else if (resource.isExecutable()) {
            name = new TerminalString(name, new TerminalColor(Color.GREEN, Color.DEFAULT)).toString();
        }
        return name;
    }

    public static String colorizeJavaMethodResource(JavaMethodResource resource) {
        String name = resource.getName();
        String[] splitName = name.split("(?=\\:\\:)");
        return splitName[0] + new TerminalString(splitName[1], new TerminalColor(Color.GREEN, Color.DEFAULT)).toString();
    }

    public static String colorizeJavaFieldResource(JavaFieldResource resource) {
        String name = resource.getName();
        String[] splitName = name.split("(?=\\:\\:)");
        return splitName[0] + new TerminalString(splitName[1], new TerminalColor(Color.GREEN, Color.DEFAULT)).toString();
    }

    public static String colorizeLabel(String label) {
        return new TerminalString(label, new TerminalColor(Color.RED, Color.DEFAULT)).toString();
    }

    public static TerminalString colorizeResourceTerminal(FileResource<?> resource) {
        TerminalString name = resource.isDirectory() ? new TerminalString(resource.getName(), new TerminalColor(Color.BLUE, Color.DEFAULT)) : (resource.isExecutable() ? new TerminalString(resource.getName(), new TerminalColor(Color.GREEN, Color.DEFAULT)) : new TerminalString(resource.getName()));
        return name;
    }
}

