/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.shell.test.ShellTest;
import org.jboss.forge.addon.shell.test.TestAeshSettingsProvider;
import org.jboss.forge.addon.shell.test.TestCommandListener;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.util.Assert;

@Singleton
public class ShellTestImpl
implements ShellTest {
    private TestCommandListener listener;
    private TestAeshSettingsProvider provider;

    @Inject
    public ShellTestImpl(TestAeshSettingsProvider provider, TestCommandListener listener) {
        this.listener = listener;
        this.provider = provider;
    }

    @Override
    public Result execute(String line) {
        Result result;
        Assert.notNull((Object)line, (String)"Line to execute cannot be null.");
        try {
            if (!line.trim().endsWith("\n")) {
                line = line + "\n";
            }
            this.listener.reset();
            this.provider.getStdIn().write(line.getBytes());
            while (!this.listener.isExecuted()) {
                Thread.sleep(10L);
            }
            result = this.listener.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute command.", e);
        }
        return result;
    }

    @Override
    public Result execute(String line, int quantity, TimeUnit unit) {
        Result result;
        Assert.notNull((Object)line, (String)"Line to execute cannot be null.");
        try {
            if (!line.trim().endsWith("\n")) {
                line = line + "\n";
            }
            this.listener.reset();
            this.provider.getStdIn().write(line.getBytes());
            long start = System.currentTimeMillis();
            while (!this.listener.isExecuted()) {
                if (System.currentTimeMillis() > start + TimeUnit.MILLISECONDS.convert(quantity, unit)) {
                    throw new TimeoutException("Timeout expired waiting for command [" + line + "].");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new ContainerException("Command [" + line + "] did not respond.", (Throwable)e);
                }
            }
            result = this.listener.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute command.", e);
        }
        return result;
    }

    @Override
    public void waitForStdOut(String value, int quantity, TimeUnit unit) throws TimeoutException {
        this.waitForStream(value, this.provider.getStdOut(), quantity, unit);
    }

    @Override
    public void waitForStdErr(String value, int quantity, TimeUnit unit) throws TimeoutException {
        this.waitForStream(value, this.provider.getStdErr(), quantity, unit);
    }

    private void waitForStream(String value, ByteArrayOutputStream stream, int quantity, TimeUnit unit) throws TimeoutException {
        stream.reset();
        try {
            this.provider.getStdIn().write(value.getBytes());
            this.provider.getStdIn().flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        long start = System.currentTimeMillis();
        while (stream.toByteArray().length == 0) {
            if (System.currentTimeMillis() > start + TimeUnit.MILLISECONDS.convert(quantity, unit)) {
                throw new TimeoutException("Timeout expired waiting for shell to respond [" + stream + "].");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ContainerException("Stream [" + stream + "] did not respond.", (Throwable)e);
            }
        }
    }

    @Override
    public OutputStream getStdIn() {
        return this.provider.getStdIn();
    }

    @Override
    public String getStdOut() {
        return this.provider.getStdOut().toString();
    }

    @Override
    public String getStdErr() {
        return this.provider.getStdErr().toString();
    }
}

