/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.shell.test.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.aesh.console.AeshConsoleImpl;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.console.settings.SettingsBuilder;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TestTerminal;
import org.jboss.forge.addon.shell.Shell;
import org.jboss.forge.addon.shell.ShellFactory;
import org.jboss.forge.addon.shell.test.ShellTest;
import org.jboss.forge.addon.ui.command.AbstractCommandExecutionListener;
import org.jboss.forge.addon.ui.command.CommandExecutionListener;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.furnace.container.cdi.events.Local;
import org.jboss.forge.furnace.event.PreShutdown;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

@Singleton
public class DefaultShellTest
implements ShellTest {
    private final TestCommandListener listener = new TestCommandListener();
    private final TestStreams provider = new TestStreams();
    @Inject
    private ShellFactory factory;
    private Shell shell;
    private final Callable<?> nullCallable = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            return null;
        }
    };
    private final KeyOperation completeChar = new KeyOperation(Key.CTRL_I, Operation.COMPLETE);

    @Override
    public Shell getShell() {
        if (this.shell == null) {
            this.shell = this.factory.createShell(OperatingSystemUtils.getTempDirectory(), this.provider.getSettings());
            this.shell.addCommandExecutionListener((CommandExecutionListener)this.listener);
        }
        return this.shell;
    }

    @PostConstruct
    public void init() {
        this.getShell();
    }

    public void teardown(@Observes @Local PreShutdown event) throws Exception {
        if (this.shell != null) {
            this.shell.close();
            this.shell = null;
        }
    }

    @Override
    public String getBuffer() {
        AeshConsoleImpl console = (AeshConsoleImpl)this.shell.getConsole();
        return console.getBuffer();
    }

    @Override
    public void execute(String line) {
        Assert.notNull((Object)line, (String)"Line to execute cannot be null.");
        try {
            if (!line.trim().endsWith(OperatingSystemUtils.getLineSeparator())) {
                line = line + OperatingSystemUtils.getLineSeparator();
            }
            this.provider.getStdIn().write(line.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Result execute(String line, int quantity, TimeUnit unit) throws TimeoutException {
        Result result;
        Assert.notNull((Object)line, (String)"Line to execute cannot be null.");
        try {
            if (!line.trim().endsWith(OperatingSystemUtils.getLineSeparator())) {
                line = line + OperatingSystemUtils.getLineSeparator();
            }
            this.listener.reset();
            this.provider.getStdIn().write(line.getBytes());
            long start = System.currentTimeMillis();
            while (!this.listener.isExecuted()) {
                if (System.currentTimeMillis() > start + TimeUnit.MILLISECONDS.convert(quantity, unit)) {
                    throw this.throwTimeout("Timeout expired waiting for command [" + line + "] to execute.");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    throw new ContainerException("Command [" + line + "] did not respond.", (Throwable)e);
                }
            }
            result = this.listener.getResult();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to execute command.", e);
        }
        return result;
    }

    @Override
    public void waitForStdOutChanged(final String value, int quantity, TimeUnit unit) throws TimeoutException {
        this.waitForStreamChanged(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultShellTest.this.provider.getStdIn().write(value.getBytes());
                DefaultShellTest.this.provider.getStdIn().flush();
                return null;
            }
        }, this.provider.getStdOut(), quantity, unit);
    }

    @Override
    public void waitForStdErrChanged(final String value, int quantity, TimeUnit unit) throws TimeoutException {
        this.waitForStreamChanged(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultShellTest.this.provider.getStdIn().write(value.getBytes());
                DefaultShellTest.this.provider.getStdIn().flush();
                return null;
            }
        }, this.provider.getStdErr(), quantity, unit);
    }

    @Override
    public String waitForStdOutChanged(Callable<?> task, int quantity, TimeUnit unit) throws TimeoutException {
        this.waitForStreamChanged(task, this.provider.getStdOut(), quantity, unit);
        return new String(this.provider.getStdOut().toByteArray());
    }

    @Override
    public String waitForStdErrChanged(Callable<?> task, int quantity, TimeUnit unit) throws TimeoutException {
        this.waitForStreamChanged(task, this.provider.getStdErr(), quantity, unit);
        return new String(this.provider.getStdErr().toByteArray());
    }

    @Override
    public void waitForStdOutValue(String expected, int timeout, TimeUnit unit) throws TimeoutException {
        this.waitForStreamValue(this.nullCallable, this.provider.getStdOut(), expected, timeout, unit);
    }

    @Override
    public void waitForStdErrValue(String expected, int timeout, TimeUnit unit) throws TimeoutException {
        this.waitForStreamValue(this.nullCallable, this.provider.getStdErr(), expected, timeout, unit);
    }

    @Override
    public void waitForStdOutValue(Callable<Void> task, String expected, int timeout, TimeUnit unit) throws TimeoutException {
        this.clearAndWaitForStreamValue(task, this.provider.getStdOut(), expected, timeout, unit);
    }

    @Override
    public void waitForStdErrValue(Callable<Void> task, String expected, int timeout, TimeUnit unit) throws TimeoutException {
        this.clearAndWaitForStreamValue(task, this.provider.getStdErr(), expected, timeout, unit);
    }

    private void waitForStreamChanged(Callable<?> task, ByteArrayOutputStream stream, int quantity, TimeUnit unit) throws TimeoutException {
        int size = stream.size();
        try {
            task.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long start = System.currentTimeMillis();
        while (stream.size() == size) {
            if (System.currentTimeMillis() >= start + TimeUnit.MILLISECONDS.convert(quantity, unit) && stream.size() == size) {
                throw this.throwTimeout("Timeout occurred while waiting for stream to be written.");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for stream to be written.", e);
            }
        }
    }

    private void clearAndWaitForStreamValue(Callable<?> task, ByteArrayOutputStream stream, String expected, int quantity, TimeUnit unit) throws TimeoutException {
        stream.reset();
        this.waitForStreamValue(task, stream, expected, quantity, unit);
    }

    private void waitForStreamValue(Callable<?> task, ByteArrayOutputStream stream, String expected, int quantity, TimeUnit unit) throws TimeoutException {
        try {
            task.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long start = System.currentTimeMillis();
        while (!new String(stream.toByteArray()).contains(expected)) {
            if (System.currentTimeMillis() >= start + TimeUnit.MILLISECONDS.convert(quantity, unit) && !new String(stream.toByteArray()).contains(expected)) {
                throw this.throwTimeout("Timeout occurred while waiting for stream value [" + expected + "].");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for stream value [" + expected + "].", e);
            }
        }
    }

    @Override
    public void waitForBufferChanged(Callable<?> task, int quantity, TimeUnit unit) throws TimeoutException {
        String buffer = this.getBuffer();
        try {
            task.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long start = System.currentTimeMillis();
        while (buffer.equals(this.getBuffer().length())) {
            if (System.currentTimeMillis() >= start + TimeUnit.MILLISECONDS.convert(quantity, unit) && buffer.equals(this.getBuffer())) {
                throw this.throwTimeout("Timeout occurred while waiting for buffer value to change from [" + buffer + "].");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for buffer value to change from [" + buffer + "].", e);
            }
        }
    }

    @Override
    public void waitForBufferValue(Callable<?> task, String expected, int quantity, TimeUnit unit) throws TimeoutException {
        try {
            task.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long start = System.currentTimeMillis();
        while (!this.getBuffer().equals(expected)) {
            if (System.currentTimeMillis() >= start + TimeUnit.MILLISECONDS.convert(quantity, unit) && !this.getBuffer().equals(expected)) {
                throw this.throwTimeout("Timeout occurred while waiting for buffer to equal value [" + expected + "].");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for buffer to equal value  [" + expected + "].", e);
            }
        }
    }

    @Override
    public OutputStream getStdIn() {
        return this.provider.getStdIn();
    }

    @Override
    public String getStdOut() {
        return this.provider.getStdOut().toString();
    }

    @Override
    public String getStdErr() {
        return this.provider.getStdErr().toString();
    }

    @Override
    public void write(String string) throws IOException {
        this.getStdIn().write(string.getBytes());
    }

    @Override
    public void sendCompletionSignal() throws IOException {
        this.getStdIn().write(this.completeChar.getFirstValue());
    }

    private TimeoutException throwTimeout(String message) throws TimeoutException {
        return new TimeoutException(message + OperatingSystemUtils.getLineSeparator() + OperatingSystemUtils.getLineSeparator() + "STDOUT: " + this.provider.getStdOut().toString() + OperatingSystemUtils.getLineSeparator() + OperatingSystemUtils.getLineSeparator() + "STDERR: " + this.provider.getStdErr().toString() + OperatingSystemUtils.getLineSeparator() + OperatingSystemUtils.getLineSeparator() + "BUFFER: [" + this.getBuffer() + "]" + OperatingSystemUtils.getLineSeparator());
    }

    @Override
    public void clearScreen() throws IOException {
        try {
            this.waitForBufferValue(new Callable<String>(){

                @Override
                public String call() throws Exception {
                    DefaultShellTest.this.getStdIn().write((Key.CTRL_U.getAsChar() + OperatingSystemUtils.getLineSeparator()).getBytes());
                    DefaultShellTest.this.provider.getStdOut().reset();
                    DefaultShellTest.this.provider.getStdErr().reset();
                    return null;
                }
            }, "", 10, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Could not clear screen within allotted timeout.", e);
        }
    }

    @Override
    public String waitForCompletion(final String expected, final String write, final int quantity, final TimeUnit unit) throws TimeoutException {
        this.waitForStdOutValue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultShellTest.this.waitForBufferValue(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        DefaultShellTest.this.write(write);
                        DefaultShellTest.this.sendCompletionSignal();
                        return null;
                    }
                }, expected, quantity, unit);
                return null;
            }
        }, expected, quantity, unit);
        return this.getStdOut();
    }

    @Override
    public String waitForCompletion(final int quantity, final TimeUnit unit) throws TimeoutException {
        final String buffer = this.getBuffer();
        this.waitForStdOutValue(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DefaultShellTest.this.waitForBufferValue(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        DefaultShellTest.this.sendCompletionSignal();
                        return null;
                    }
                }, buffer, quantity, unit);
                return null;
            }
        }, buffer, quantity, unit);
        return this.getStdOut();
    }

    public class TestCommandListener
    extends AbstractCommandExecutionListener {
        Result result;

        public void preCommandExecuted(UICommand command, UIExecutionContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCommandExecuted(UICommand command, UIExecutionContext context, Result result) {
            TestCommandListener testCommandListener = this;
            synchronized (testCommandListener) {
                this.result = result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postCommandFailure(UICommand command, UIExecutionContext context, Throwable failure) {
            TestCommandListener testCommandListener = this;
            synchronized (testCommandListener) {
                this.result = Results.fail((String)"Error encountered during command execution.", (Throwable)failure);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isExecuted() {
            TestCommandListener testCommandListener = this;
            synchronized (testCommandListener) {
                return this.result != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result getResult() {
            TestCommandListener testCommandListener = this;
            synchronized (testCommandListener) {
                return this.result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            TestCommandListener testCommandListener = this;
            synchronized (testCommandListener) {
                this.result = null;
            }
        }
    }

    private class TestStreams {
        private final PipedOutputStream stdin = new PipedOutputStream();
        private final ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        private final ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        private PipedInputStream inputStream;
        private Settings settings;

        private TestStreams() {
        }

        public Settings getSettings() {
            try {
                this.inputStream = new PipedInputStream(this.stdin);
                this.settings = new SettingsBuilder().inputStream((InputStream)this.inputStream).outputStream(new PrintStream(this.stdout)).outputStreamError(new PrintStream(this.stderr)).name("test").logging(true).terminal((Terminal)new TestTerminal()).create();
                this.settings.getOperationManager().addOperation(new KeyOperation(Key.ENTER, Operation.NEW_LINE));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not configure Shell.", e);
            }
            return this.settings;
        }

        public synchronized OutputStream getStdIn() {
            return this.stdin;
        }

        public synchronized ByteArrayOutputStream getStdOut() {
            return this.stdout;
        }

        public synchronized ByteArrayOutputStream getStdErr() {
            return this.stderr;
        }
    }
}

