/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.example.wizards;

import javax.inject.Inject;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.example.wizards.ExampleStepTwo;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;

public class ExampleStepOne
implements UIWizardStep {
    @Inject
    private UIInput<String> address;
    @Inject
    private UIInput<String> password;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(this.getClass()).name("Step 1").description("Enter your Address");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ((UIInput)this.address.setLabel("Address:")).setRequired(true);
        ((HintsFacet)this.password.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.SECRET");
        builder.add(this.address).add(this.password);
    }

    public void validate(UIValidationContext context) {
        String value = (String)this.address.getValue();
        if (value != null && !value.isEmpty() && !value.matches("[a-zA-Z0-9, ]+")) {
            context.addValidationError(this.address, "Address contains invalid characters");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        UISelection selection = context.getInitialSelection();
        return !selection.isEmpty();
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return Results.navigateTo(ExampleStepTwo.class);
    }
}

