/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.example.wizards;

import java.util.Arrays;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.example.wizards.Career;
import org.jboss.forge.addon.ui.example.wizards.ExampleSelectComponents;
import org.jboss.forge.addon.ui.example.wizards.ExampleStepOne;
import org.jboss.forge.addon.ui.example.wizards.ExampleStepTwo;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class ExampleWizard
extends AbstractUICommand
implements UIWizard {
    @Inject
    @WithAttributes(label="First Name", shortName=102, required=true)
    private UIInput<String> firstName;
    @Inject
    @WithAttributes(label="Show Select Components", shortName=115)
    private UISelectOne<Boolean> showSelectComponents;
    @Inject
    @WithAttributes(label="One Career", shortName=111)
    private UISelectOne<Career> career;
    @Inject
    @WithAttributes(label="Many Career", shortName=109)
    private UISelectMany<Career> manyCareer;
    @Inject
    @WithAttributes(label="Folder Location:", shortName=100)
    private UIInput<DirectoryResource> directory;
    @Inject
    @WithAttributes(label="Go to Last Step", shortName=103)
    private UIInput<Boolean> goToLastStep;
    @Inject
    private UISelectOne<String> valueWithSpaces;
    @Inject
    private UIInputMany<String> manyValues;
    @Inject
    private UISelectMany<String> selectManyValues;

    public Metadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("Wizard").description("This is the First screen of the Wizard");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ((UIInput)((UIInput)this.firstName.setRequired(true)).setRequiredMessage("First Name must be informed !")).setNote("This is a UIInput");
        ((UISelectOne)this.valueWithSpaces.setValueChoices(Arrays.asList("Value 1", "Value 2", "Value 10", "Value 100"))).setNote("This is a UISelectOne");
        ((UISelectMany)this.selectManyValues.setValueChoices(Arrays.asList("A", "B", "C", "AA", "BB"))).setNote("This is a UISelectMany");
        this.manyValues.setNote("This is a UIInputMany");
        this.directory.setNote((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                DirectoryResource value = (DirectoryResource)ExampleWizard.this.directory.getValue();
                return value == null ? null : "Path: " + value.getFullyQualifiedName();
            }
        });
        builder.add(this.firstName).add(this.showSelectComponents).add(this.goToLastStep).add(this.directory).add(this.valueWithSpaces).add(this.career).add(this.manyCareer).add(this.manyValues).add(this.selectManyValues);
    }

    public void validate(UIValidationContext context) {
        String value = (String)this.firstName.getValue();
        if (value != null && !value.isEmpty() && !value.matches("[a-zA-Z]+")) {
            context.addValidationError(this.firstName, "First Name contains invalid characters");
        }
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        if (this.showSelectComponents.getValue() != null && ((Boolean)this.showSelectComponents.getValue()).booleanValue()) {
            return Results.navigateTo(ExampleSelectComponents.class);
        }
        if (this.goToLastStep.getValue() != null && ((Boolean)this.goToLastStep.getValue()).booleanValue()) {
            return Results.navigateTo(ExampleStepTwo.class);
        }
        return Results.navigateTo(ExampleStepOne.class);
    }
}

