/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.example.commands;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIInputMany;
import org.jboss.forge.addon.ui.input.UISelectMany;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;

public class RequiredCommand
extends AbstractUICommand {
    @Inject
    @WithAttributes(label="Name", required=true)
    UIInput<String> name;
    @Inject
    @WithAttributes(label="Names", required=true)
    UIInputMany<String> names;
    @Inject
    @WithAttributes(label="Names Select One", required=true)
    UISelectOne<String> nameSelectOne;
    @Inject
    @WithAttributes(label="Names Select Many", required=true)
    UISelectMany<String> nameSelectMany;

    public void initializeUI(UIBuilder builder) throws Exception {
        List<String> optionValues = Arrays.asList("APPLE", "ORANGE", "PINEAPPLE");
        this.nameSelectOne.setValueChoices(optionValues);
        this.nameSelectMany.setValueChoices(optionValues);
        builder.add(this.name).add(this.names).add(this.nameSelectOne).add(this.nameSelectMany);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        StringBuilder result = new StringBuilder();
        result.append("Name = ").append((String)this.name.getValue()).append("\n");
        result.append("Names = ").append(this.names.getValue()).append("\n");
        result.append("Names Select One = ").append((String)this.nameSelectOne.getValue()).append("\n");
        result.append("Names Select Many = ").append(this.nameSelectMany.getValue()).append("\n");
        return Results.success((String)result.toString());
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(((Object)((Object)this)).getClass()).name("required-command");
    }
}

