/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.example.wizards;

import java.util.Arrays;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.example.wizards.Bean;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;

public class ExampleSelectComponents
implements UIWizardStep {
    @Inject
    private UISelectOne<Bean> radioBean;
    @Inject
    private UISelectOne<Bean> radioBeanTwo;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(this.getClass()).name("Step 2").description("Select a folder");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ((HintsFacet)this.radioBean.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.RADIO");
        ((HintsFacet)this.radioBeanTwo.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.RADIO");
        this.radioBean.setValueChoices(Arrays.asList(new Bean("One"), new Bean("Two"), new Bean("Three")));
        this.radioBeanTwo.setValueChoices(Arrays.asList(new Bean("A"), new Bean("B"), new Bean("C")));
        Converter<Bean, String> converter = new Converter<Bean, String>(){

            public String convert(Bean source) {
                return source.getName();
            }
        };
        this.radioBean.setItemLabelConverter((Converter)converter);
        this.radioBeanTwo.setItemLabelConverter((Converter)converter);
        builder.add(this.radioBean).add(this.radioBeanTwo);
    }

    public void validate(UIValidationContext context) {
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }

    public boolean isEnabled(UIContext context) {
        UISelection selection = context.getInitialSelection();
        return !selection.isEmpty();
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }
}

