/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.example.wizards.subflow;

import javax.inject.Inject;
import org.jboss.forge.addon.ui.command.AbstractUICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.example.wizards.subflow.FlowOneStep;
import org.jboss.forge.addon.ui.example.wizards.subflow.FlowTwoStep;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class ExampleFlow
extends AbstractUICommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Name", required=true)
    private UIInput<String> name;
    @Inject
    @WithAttributes(label="Number", required=true)
    private UIInput<Integer> number;

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.name).add(this.number);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }

    public void validate(UIValidationContext validator) {
        validator.addValidationInformation(this.name, "Input the name and click that next button");
        if ("foo".equals(this.name.getValue())) {
            validator.addValidationWarning(this.name, "Foo? Really? Ok...");
        }
        if (this.number.getValue() != null && (Integer)this.number.getValue() != 42) {
            validator.addValidationError(this.number, "You can't proceed without knowing the secret of life,the universe and everything!");
        }
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.from((UICommandMetadata)super.getMetadata(context), ((Object)((Object)this)).getClass()).name("flow").category(Categories.create((String[])new String[]{"Example"}));
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return Results.navigateTo(FlowOneStep.class, (Class[])new Class[]{FlowTwoStep.class});
    }
}

