/*
 * Decompiled with CFR 0.152.
 */
package org.example.event;

import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.example.event.EventPayload1;
import org.example.event.EventPayload2;

@Singleton
public class EventService {
    @Inject
    @Named(value="1")
    private Event<Object> request;
    private boolean localRequestRecieved = false;
    private boolean remoteResponseRecieved = false;
    private boolean wrongResponseRecieved = false;

    public void fire() {
        this.request.fire((Object)new EventPayload1());
    }

    public void fireNonRemote() {
        this.request.fire((Object)new EventPayload2());
    }

    public void handleLocalRequest(@Observes @Named(value="1") Object event) {
        this.localRequestRecieved = true;
    }

    public void handleRemoteResponse(@Observes @Named(value="2") Object event) {
        this.remoteResponseRecieved = true;
    }

    public void handleWrongResponse(@Observes @Named(value="3") Object event) {
        this.wrongResponseRecieved = true;
    }

    public boolean isLocalRequestRecieved() {
        return this.localRequestRecieved;
    }

    public boolean isRemoteResponseRecieved() {
        return this.remoteResponseRecieved;
    }

    public boolean isWrongResponseRecieved() {
        return this.wrongResponseRecieved;
    }

    public String toString() {
        return "EventService";
    }
}

