/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.repositories;

import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.VersionRange;
import org.jboss.forge.furnace.versions.Versions;

public class AddonDependencyEntry {
    private String name;
    private VersionRange version;
    private boolean exported;
    private boolean optional;

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isExported() {
        return this.exported;
    }

    public String getName() {
        return this.name;
    }

    public VersionRange getVersionRange() {
        return this.version;
    }

    public static AddonDependencyEntry create(String name, String versionRange) {
        return AddonDependencyEntry.create(name, Versions.parseMultipleVersionRange(versionRange), false, false);
    }

    public static AddonDependencyEntry create(String name, VersionRange range) {
        return AddonDependencyEntry.create(name, range, false, false);
    }

    public static AddonDependencyEntry create(String name, String versionRange, boolean exported) {
        return AddonDependencyEntry.create(name, Versions.parseMultipleVersionRange(versionRange), exported, false);
    }

    public static AddonDependencyEntry create(String name, VersionRange range, boolean exported) {
        return AddonDependencyEntry.create(name, range, exported, false);
    }

    public static AddonDependencyEntry create(String name, String versionRange, boolean exported, boolean optional) {
        return AddonDependencyEntry.create(name, Versions.parseMultipleVersionRange(versionRange), exported, optional);
    }

    public static AddonDependencyEntry create(String name, VersionRange range, boolean exported, boolean optional) {
        Assert.notNull(name, "Addon name must not be null.");
        Assert.notNull(range, "Addon version must not be null.");
        AddonDependencyEntry entry = new AddonDependencyEntry();
        entry.name = name;
        entry.version = range;
        entry.exported = exported;
        entry.optional = optional;
        return entry;
    }

    public String toString() {
        return "name=" + this.name + ", version=" + this.version + ", exported=" + this.exported + ", optional=" + this.optional;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonDependencyEntry other = (AddonDependencyEntry)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

