/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.SecurityActions;

public class ClassLoaders {
    private static Logger log = Logger.getLogger(ClassLoaders.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeIn(ClassLoader loader, Callable<T> task) throws Exception {
        if (task == null) {
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("ClassLoader [" + loader + "] task began.");
        }
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader(loader);
            T t = task.call();
            return t;
        }
        finally {
            SecurityActions.setContextClassLoader(original);
            if (log.isLoggable(Level.FINE)) {
                log.fine("ClassLoader [" + loader + "] task ended.");
            }
        }
    }

    public static boolean containsClass(ClassLoader loader, Class<?> type) {
        Assert.notNull(loader, "Class loader to inspect must not be null.");
        Assert.notNull(type, "Class to find must not be null.");
        try {
            return loader.loadClass(type.getName()).equals(type);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean containsClass(ClassLoader loader, String type) {
        Assert.notNull(loader, "Class loader to inspect must not be null.");
        Assert.notNull(type, "Class to find must not be null.");
        try {
            loader.loadClass(type);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?> loadClass(ClassLoader loader, String typeName) {
        Assert.notNull(loader, "Class loader to inspect must not be null.");
        Assert.notNull(typeName, "Class name to load must not be null.");
        try {
            return loader.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException("Could not locate class [" + typeName + "] in Loader [" + loader + "]", e);
        }
    }

    public static Class<?> loadClass(ClassLoader loader, Class<?> type) {
        Assert.notNull(loader, "Class loader to inspect must not be null.");
        Assert.notNull(type, "Class to load must not be null.");
        try {
            return loader.loadClass(type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException("Could not locate class [" + type.getName() + "] in Loader [" + loader + "]", e);
        }
    }

    public static boolean ownsClass(ClassLoader loader, Class<?> type) {
        Assert.notNull(loader, "Class loader to inspect must not be null.");
        Assert.notNull(type, "Class to find must not be null.");
        try {
            Class<?> clazz = loader.loadClass(type.getName());
            return clazz.equals(type) && clazz.getClassLoader().equals(loader);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

