/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.io.File;

public final class OperatingSystemUtils {
    private static boolean PRETEND_WINDOWS = Boolean.getBoolean("forge.pretend_windows");
    private static String operatingSystem = null;

    public static String getOsName() {
        if (operatingSystem == null) {
            operatingSystem = System.getProperty("os.name");
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return PRETEND_WINDOWS || OperatingSystemUtils.getOsName().startsWith("Windows") || OperatingSystemUtils.getOsName().startsWith("windows");
    }

    public static boolean isOSX() {
        return OperatingSystemUtils.getOsName().startsWith("Mac") || OperatingSystemUtils.getOsName().startsWith("mac");
    }

    public static boolean isLinux() {
        return OperatingSystemUtils.getOsName().startsWith("Linux") || OperatingSystemUtils.getOsName().startsWith("linux");
    }

    public static File getForgeHomeDir() {
        return new File(System.getProperty("forge.home")).getAbsoluteFile();
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    public static String getUserHomePath() {
        return OperatingSystemUtils.getUserHomeDir().getAbsolutePath();
    }

    public static File getUserForgeDir() {
        return new File(OperatingSystemUtils.getUserHomeDir(), ".forge").getAbsoluteFile();
    }

    public static void setPretendWindows(boolean value) {
        PRETEND_WINDOWS = value;
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static String getSafeFilename(String filename) {
        String result = filename;
        if (result != null) {
            result = result.replaceAll("[^a-zA-Z0-9]+", "-").replaceAll("^-+", "");
        }
        return result;
    }
}

