/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public final class Strings {
    public static final String EMPTY = "";
    private static final long MSEC = 1L;
    private static final long SECS = 1000L;
    private static final long MINS = 60000L;
    private static final long HOUR = 3600000L;
    private static final String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"};
    private static final String[] ejbQlIdentifiers = new String[]{"AND", "AS", "BETWEEN", "DISTINCT", "EMPTY", "FALSE", "FROM", "IN", "IS", "LIKE", "MEMBER", "NOT", "NULL", "OBJECT", "OF", "OR", "SELECT", "UNKNOWN", "TRUE", "WHERE"};

    public static String subst(StringBuffer buff, String from, String to, String string) {
        int begin = 0;
        int end = 0;
        while ((end = string.indexOf(from, end)) != -1) {
            buff.append(string.substring(begin, end));
            buff.append(to);
            end = begin = end + from.length();
        }
        buff.append(string.substring(begin, string.length()));
        return buff.toString();
    }

    public static String subst(String from, String to, String string) {
        return Strings.subst(new StringBuffer(), from, to, string);
    }

    public static String subst(StringBuffer buff, String string, Map<?, ?> map, String beginToken, String endToken) {
        Range range;
        int begin = 0;
        int rangeEnd = 0;
        while ((range = Strings.rangeOf(beginToken, endToken, string, rangeEnd)) != null) {
            buff.append(string.substring(begin, range.begin));
            String key = string.substring(range.begin + beginToken.length(), range.end);
            Object value = map.get(key);
            if (value == null) {
                value = EMPTY;
            }
            buff.append(value);
            rangeEnd = begin = range.end + endToken.length();
        }
        buff.append(string.substring(begin, string.length()));
        return buff.toString();
    }

    public static String subst(String string, Map<?, ?> map, String beginToken, String endToken) {
        return Strings.subst(new StringBuffer(), string, map, beginToken, endToken);
    }

    public static String subst(StringBuffer buff, String string, String[] replace, char token) {
        int i = string.length();
        for (int j = 0; j >= 0 && j < i; ++j) {
            char c = string.charAt(j);
            if (c == token) {
                if (j == i) continue;
                int k = Character.digit(string.charAt(j + 1), 10);
                if (k == -1) {
                    buff.append(string.charAt(j + 1));
                } else if (k < replace.length) {
                    buff.append(replace[k]);
                }
                ++j;
                continue;
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static String subst(String string, String[] replace, char token) {
        return Strings.subst(new StringBuffer(), string, replace, token);
    }

    public static String subst(String string, String[] replace) {
        return Strings.subst(new StringBuffer(), string, replace, '%');
    }

    public static Range rangeOf(String beginToken, String endToken, String string, int fromIndex) {
        int end;
        int begin = string.indexOf(beginToken, fromIndex);
        if (begin != -1 && (end = string.indexOf(endToken, begin + 1)) != -1) {
            return new Range(begin, end);
        }
        return null;
    }

    public static Range rangeOf(String beginToken, String endToken, String string) {
        return Strings.rangeOf(beginToken, endToken, string, 0);
    }

    public static String[] split(String string, String delim, int limit) {
        int count = Strings.count(string, delim) + 1;
        if (limit > 0 && count > limit) {
            count = limit;
        }
        String[] strings = new String[count];
        int begin = 0;
        for (int i = 0; i < count; ++i) {
            int end = string.indexOf(delim, begin);
            if (end == -1 || i + 1 == count) {
                end = string.length();
            }
            strings[i] = end == 0 ? EMPTY : string.substring(begin, end);
            begin = end + 1;
        }
        return strings;
    }

    public static String[] split(String string, String delim) {
        return Strings.split(string, delim, -1);
    }

    public static String join(StringBuffer buff, Object[] array, String delim) {
        boolean haveDelim = delim != null;
        for (int i = 0; i < array.length; ++i) {
            buff.append(array[i]);
            if (!haveDelim || i + 1 >= array.length) continue;
            buff.append(delim);
        }
        return buff.toString();
    }

    public static String join(Object[] array, String delim) {
        return Strings.join(new StringBuffer(), array, delim);
    }

    public static String join(Object[] array) {
        return Strings.join(array, null);
    }

    public static String join(byte[] array) {
        Object[] bytes = new Byte[array.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = new Byte(array[i]);
        }
        return Strings.join(bytes, null);
    }

    public static String join(StringBuffer buff, Object[] array, String prefix, String separator, String suffix) {
        buff.append(prefix);
        Strings.join(buff, array, separator);
        buff.append(suffix);
        return buff.toString();
    }

    public static String join(Object[] array, String prefix, String separator, String suffix) {
        return Strings.join(new StringBuffer(), array, prefix, separator, suffix);
    }

    public static int count(String string, String substring) {
        int count = 0;
        int idx = 0;
        while ((idx = string.indexOf(substring, idx)) != -1) {
            ++idx;
            ++count;
        }
        return count;
    }

    public static int count(String string, char c) {
        return Strings.count(string, String.valueOf(c));
    }

    public static String pad(StringBuffer buff, String string, int count) {
        for (int i = 0; i < count; ++i) {
            buff.append(string);
        }
        return buff.toString();
    }

    public static String pad(String string, int count) {
        return Strings.pad(new StringBuffer(), string, count);
    }

    public static String pad(Object obj, int count) {
        return Strings.pad(new StringBuffer(), String.valueOf(obj), count);
    }

    public static boolean compare(String me, String you) {
        if (me == you) {
            return true;
        }
        if (me == null && you != null) {
            return false;
        }
        return me.equals(you);
    }

    public static boolean isEmpty(String string) {
        return string.equals(EMPTY);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.equals(EMPTY);
    }

    public static int nthIndexOf(String string, String token, int index) {
        int j = 0;
        for (int i = 0; i < index && (j = string.indexOf(token, j + 1)) != -1; ++i) {
        }
        return j;
    }

    public static String capitalize(String string) {
        if (string == null) {
            throw new IllegalArgumentException("string");
        }
        if (string.equals(EMPTY)) {
            throw new IllegalArgumentException("string");
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public static String[] trim(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].trim();
        }
        return strings;
    }

    public static URL toURL(String urlspec, String relativePrefix) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                url = Strings.makeURLFromFilespec(url.getFile(), relativePrefix);
            }
        }
        catch (Exception e) {
            try {
                url = Strings.makeURLFromFilespec(urlspec, relativePrefix);
            }
            catch (IOException n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    public static URI toURI(String urispec, String relativePrefix) throws URISyntaxException {
        URI uri = (urispec = urispec.trim()).startsWith("file:") ? Strings.makeURIFromFilespec(urispec.substring(5), relativePrefix) : new URI(urispec);
        return uri;
    }

    private static URL makeURLFromFilespec(String filespec, String relativePrefix) throws IOException {
        File file = new File(Strings.decode(filespec));
        if (relativePrefix != null && !file.isAbsolute()) {
            file = new File(relativePrefix, filespec);
        }
        file = file.getCanonicalFile();
        return file.toURI().toURL();
    }

    private static String decode(String filespec) {
        try {
            return URLDecoder.decode(filespec, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error decoding filespec: " + filespec, e);
        }
    }

    private static URI makeURIFromFilespec(String filespec, String relativePrefix) {
        File file = new File(Strings.decode(filespec));
        if (relativePrefix != null && !file.isAbsolute()) {
            file = new File(relativePrefix, filespec);
        }
        return file.toURI();
    }

    public static URL toURL(String urlspec) throws MalformedURLException {
        return Strings.toURL(urlspec, null);
    }

    public static URI toURI(String urispec) throws URISyntaxException {
        return Strings.toURI(urispec, null);
    }

    public static final boolean isJavaKeyword(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!keywords[i].equals(s)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isEjbQlIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        for (int i = 0; i < ejbQlIdentifiers.length; ++i) {
            if (!ejbQlIdentifiers[i].equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isValidJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] c = s.toCharArray();
        if (!Character.isJavaIdentifierStart(c[0])) {
            return false;
        }
        for (int i = 1; i < c.length; ++i) {
            if (Character.isJavaIdentifierPart(c[i])) continue;
            return false;
        }
        return true;
    }

    public static String removeWhiteSpace(String s) {
        String retn = null;
        if (s != null) {
            int len = s.length();
            StringBuffer sbuf = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (Character.isWhitespace(c)) continue;
                sbuf.append(c);
            }
            retn = sbuf.toString();
        }
        return retn;
    }

    public static final String defaultToString(Object object) {
        if (object == null) {
            return "null";
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }

    public static final void defaultToString(StringBuilder buffer, Object object) {
        if (object == null) {
            buffer.append("null");
        } else {
            buffer.append(object.getClass().getName());
            buffer.append('@');
            buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    public static final void defaultToString(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("null");
        } else {
            buffer.append(object.getClass().getName());
            buffer.append('@');
            buffer.append(Integer.toHexString(System.identityHashCode(object)));
        }
    }

    public static long parseTimePeriod(String period) {
        try {
            long factor;
            String s = period.toLowerCase();
            if (s.endsWith("msec")) {
                s = s.substring(0, s.lastIndexOf("msec"));
                factor = 1L;
            } else if (s.endsWith("sec")) {
                s = s.substring(0, s.lastIndexOf("sec"));
                factor = 1000L;
            } else if (s.endsWith("min")) {
                s = s.substring(0, s.lastIndexOf("min"));
                factor = 60000L;
            } else if (s.endsWith("h")) {
                s = s.substring(0, s.lastIndexOf("h"));
                factor = 3600000L;
            } else {
                factor = 1L;
            }
            return Long.parseLong(s) * factor;
        }
        catch (RuntimeException e) {
            throw new NumberFormatException("For input time period: '" + period + "'");
        }
    }

    public static long parsePositiveTimePeriod(String period) {
        long retval = Strings.parseTimePeriod(period);
        if (retval < 0L) {
            throw new NumberFormatException("Negative input time period: '" + period + "'");
        }
        return retval;
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String trimLeadingWhitespace(String str) {
        return Strings.trimLeadingCharacter(str, CharacterFilter.WHITESPACE);
    }

    public static String trimLeadingCharacter(String str, final char leadingCharacter) {
        return Strings.trimLeadingCharacter(str, new CharacterFilter(){

            @Override
            public boolean isCharacterLegal(char character) {
                return character == leadingCharacter;
            }
        });
    }

    public static String trimLeadingCharacter(String str, CharacterFilter checker) {
        if (!Strings.hasLength(str)) {
            return str;
        }
        if (checker == null) {
            throw new IllegalArgumentException("Null character checker");
        }
        StringBuffer buf = new StringBuffer(str);
        while (buf.length() > 0 && checker.isCharacterLegal(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }

    public static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        String[] parts = Strings.tokenizeToStringArray(localeString, "_ ", false, false);
        String language = parts.length > 0 ? parts[0] : EMPTY;
        String country = parts.length > 1 ? parts[1] : EMPTY;
        String variant = EMPTY;
        if (parts.length >= 2 && (variant = Strings.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country) + country.length()))).startsWith("_")) {
            variant = Strings.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    public static interface CharacterFilter {
        public static final CharacterFilter WHITESPACE = new WhitespaceChecker();

        public boolean isCharacterLegal(char var1);

        public static class WhitespaceChecker
        implements CharacterFilter {
            @Override
            public boolean isCharacterLegal(char character) {
                return Character.isWhitespace(character);
            }
        }
    }

    public static class Range {
        public int begin;
        public int end;

        public Range(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public Range() {
        }
    }
}

