/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven.addon;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.maven.MavenContainer;
import org.jboss.forge.furnace.manager.maven.addon.AddonDependencySelector;
import org.jboss.forge.furnace.manager.maven.addon.AddonDependencyTraverser;
import org.jboss.forge.furnace.manager.maven.addon.AddonInfoBuilder;
import org.jboss.forge.furnace.manager.maven.addon.LazyAddonInfo;
import org.jboss.forge.furnace.manager.maven.util.MavenRepositories;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.manager.spi.AddonInfo;

public class MavenAddonDependencyResolver
implements AddonDependencyResolver {
    private static final String FORGE_ADDON_CLASSIFIER = "forge-addon";
    private final MavenContainer container = new MavenContainer();

    public AddonInfo resolveAddonDependencyHierarchy(AddonId addonId) {
        String coords = this.toMavenCoords(addonId);
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.container.getSettings();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        DependencyNode dependencyNode = this.traverseAddonGraph(coords, system, settings, session);
        return this.fromNode(addonId, dependencyNode, system, settings, session);
    }

    public File[] resolveResources(AddonId addonId) {
        DependencyResult result;
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.container.getSettings();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        String mavenCoords = this.toMavenCoords(addonId);
        DefaultArtifact queryArtifact = new DefaultArtifact(mavenCoords);
        session.setDependencyTraverser((DependencyTraverser)new AddonDependencyTraverser());
        session.setDependencySelector((DependencySelector)new AddonDependencySelector());
        Dependency dependency = new Dependency((Artifact)queryArtifact, null);
        List<RemoteRepository> repositories = MavenRepositories.getRemoteRepositories(this.container, settings);
        CollectRequest collectRequest = new CollectRequest(dependency, repositories);
        try {
            result = system.resolveDependencies((RepositorySystemSession)session, new DependencyRequest(collectRequest, null));
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException(e);
        }
        HashSet<File> files = new HashSet<File>();
        List artifactResults = result.getArtifactResults();
        for (ArtifactResult artifactResult : artifactResults) {
            Artifact artifact = artifactResult.getArtifact();
            if (FORGE_ADDON_CLASSIFIER.equals(artifact.getClassifier()) && !mavenCoords.equals(artifact.toString())) continue;
            files.add(artifact.getFile());
        }
        return files.toArray(new File[files.size()]);
    }

    public AddonId[] resolveVersions(String addonName) {
        String version;
        String addonNameSplit;
        String[] split = addonName.split(",");
        if (split.length == 2) {
            addonNameSplit = split[0];
            version = split[1];
        } else {
            addonNameSplit = addonName;
            version = null;
        }
        VersionRangeResult versions = this.getVersions(addonNameSplit, version);
        List versionsList = versions.getVersions();
        int size = versionsList.size();
        AddonId[] addons = new AddonId[size];
        for (int i = 0; i < size; ++i) {
            addons[i] = AddonId.from((String)addonName, (String)((Version)versionsList.get(i)).toString());
        }
        return addons;
    }

    private VersionRangeResult getVersions(String addonName, String version) {
        try {
            String[] split = addonName.split(",");
            if (split.length == 2) {
                version = split[1];
            }
            if (version == null || version.isEmpty()) {
                version = "[,)";
            } else if (!version.matches("(\\(|\\[).*?(\\)|\\])")) {
                version = "[" + version + "]";
            }
            RepositorySystem system = this.container.getRepositorySystem();
            Settings settings = this.container.getSettings();
            DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
            DefaultArtifact artifact = new DefaultArtifact(this.toMavenCoords(AddonId.from((String)addonName, (String)version)));
            List<RemoteRepository> repositories = MavenRepositories.getRemoteRepositories(this.container, settings);
            VersionRangeRequest rangeRequest = new VersionRangeRequest((Artifact)artifact, repositories, null);
            VersionRangeResult rangeResult = system.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
            return rangeResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to look up versions for [" + addonName + "]", e);
        }
    }

    private AddonInfo fromNode(AddonId id, DependencyNode dependencyNode, RepositorySystem system, Settings settings, DefaultRepositorySystemSession session) {
        AddonInfoBuilder builder = AddonInfoBuilder.from(id);
        List children = dependencyNode.getChildren();
        for (DependencyNode child : children) {
            Dependency dependency = child.getDependency();
            Artifact artifact = dependency.getArtifact();
            if (!this.isAddon(artifact)) continue;
            AddonId childId = this.toAddonId(artifact);
            boolean exported = false;
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope != null && !optional) {
                if ("compile".equalsIgnoreCase(scope) || "runtime".equalsIgnoreCase(scope)) {
                    exported = true;
                } else if ("provided".equalsIgnoreCase(scope)) {
                    exported = false;
                }
            }
            DependencyNode node = this.traverseAddonGraph(this.toMavenCoords(childId), system, settings, session);
            AddonInfo addonInfo = this.fromNode(childId, node, system, settings, session);
            if (optional) {
                builder.addOptionalDependency(addonInfo, exported);
                continue;
            }
            builder.addRequiredDependency(addonInfo, exported);
        }
        return new LazyAddonInfo(this, builder);
    }

    private DependencyNode traverseAddonGraph(String coords, RepositorySystem system, Settings settings, DefaultRepositorySystemSession session) {
        CollectResult result;
        session.setDependencyTraverser((DependencyTraverser)new AddonDependencyTraverser());
        session.setDependencySelector((DependencySelector)new AddonDependencySelector());
        DefaultArtifact queryArtifact = new DefaultArtifact(coords);
        List<RemoteRepository> repositories = MavenRepositories.getRemoteRepositories(this.container, settings);
        CollectRequest collectRequest = new CollectRequest(new Dependency((Artifact)queryArtifact, null), repositories);
        try {
            result = system.collectDependencies((RepositorySystemSession)session, collectRequest);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(e);
        }
        return result.getRoot();
    }

    private String toMavenCoords(AddonId addonId) {
        String coords = addonId.getName() + ":jar:" + FORGE_ADDON_CLASSIFIER + ":" + addonId.getVersion();
        return coords;
    }

    private boolean isAddon(Artifact artifact) {
        return FORGE_ADDON_CLASSIFIER.equals(artifact.getClassifier());
    }

    private AddonId toAddonId(Artifact artifact) {
        if (this.isAddon(artifact)) {
            return AddonId.from((String)(artifact.getGroupId() + ":" + artifact.getArtifactId()), (String)artifact.getBaseVersion());
        }
        throw new IllegalArgumentException("Not a forge-addon: " + artifact);
    }
}

