/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;

public class ClasspathWorkspaceReader
implements WorkspaceReader {
    private static final Logger log = Logger.getLogger(ClasspathWorkspaceReader.class.getName());
    private static final String CLASS_PATH_KEY = "java.class.path";
    private static final String SUREFIRE_CLASS_PATH_KEY = "surefire.test.class.path";
    private final Set<String> classPathEntries = new LinkedHashSet<String>();
    private final Map<String, File> classpathFileInfoCache = new HashMap<String, File>();
    private final Map<File, File> pomFileInfoCache = new HashMap<File, File>();
    private final Map<File, Artifact> foundArtifactCache = new HashMap<File, Artifact>();
    private WorkspaceRepository repository = new WorkspaceRepository("classpath");

    public ClasspathWorkspaceReader() {
        String classPath = System.getProperty(CLASS_PATH_KEY);
        String surefireClassPath = System.getProperty(SUREFIRE_CLASS_PATH_KEY);
        this.classPathEntries.addAll(this.getClassPathEntries(surefireClassPath));
        this.classPathEntries.addAll(this.getClassPathEntries(classPath));
    }

    public WorkspaceRepository getRepository() {
        return this.repository;
    }

    public File findArtifact(Artifact artifact) {
        for (String classpathEntry : this.classPathEntries) {
            Artifact foundArtifact;
            File pomFile;
            File file = this.getClasspathFile(classpathEntry);
            if (file.isDirectory()) {
                Artifact foundArtifact2;
                File pomFile2 = this.getPomFile(file);
                if (!pomFile2.isFile() || !(foundArtifact2 = this.getFoundArtifact(pomFile2)).getGroupId().equals(artifact.getGroupId()) || !foundArtifact2.getArtifactId().equals(artifact.getArtifactId()) || !foundArtifact2.getBaseVersion().equals(artifact.getBaseVersion())) continue;
                if ("pom".equals(artifact.getExtension())) {
                    return pomFile2;
                }
                return new File(file.getParentFile(), "classes");
            }
            if (!file.isFile()) continue;
            StringBuilder name = new StringBuilder(artifact.getArtifactId()).append("-").append(artifact.getBaseVersion());
            if (!file.getName().contains(name.toString())) continue;
            if ("pom".equals(artifact.getExtension()) && (pomFile = new File(file.getParentFile().getParentFile(), "pom.xml")).isFile() && (foundArtifact = this.getFoundArtifact(pomFile)).getGroupId().equals(artifact.getGroupId()) && foundArtifact.getArtifactId().equals(artifact.getArtifactId()) && foundArtifact.getBaseVersion().equals(artifact.getBaseVersion())) {
                return pomFile;
            }
            String classifier = artifact.getClassifier();
            if (classifier != null && !classifier.isEmpty()) {
                name.append("-").append(classifier);
            }
            name.append(".").append(artifact.getExtension());
            if (!file.getName().equals(name.toString())) continue;
            return file;
        }
        return null;
    }

    public List<String> findVersions(Artifact artifact) {
        TreeSet<String> versions = new TreeSet<String>();
        for (String classpathEntry : this.classPathEntries) {
            Artifact foundArtifact;
            File pomFile;
            File file = this.getClasspathFile(classpathEntry);
            if (file.isDirectory()) {
                Artifact foundArtifact2;
                File pomFile2 = this.getPomFile(file);
                if (!pomFile2.isFile() || !(foundArtifact2 = this.getFoundArtifact(pomFile2)).getGroupId().equals(artifact.getGroupId()) || !foundArtifact2.getArtifactId().equals(artifact.getArtifactId())) continue;
                versions.add(foundArtifact2.getBaseVersion());
                continue;
            }
            if (!file.isFile()) continue;
            StringBuilder name = new StringBuilder(artifact.getArtifactId()).append("-").append(artifact.getBaseVersion());
            if (!file.getName().contains(name.toString()) || !"pom".equals(artifact.getExtension()) || !(pomFile = new File(file.getParentFile().getParentFile(), "pom.xml")).isFile() || !(foundArtifact = this.getFoundArtifact(pomFile)).getGroupId().equals(artifact.getGroupId()) || !foundArtifact.getArtifactId().equals(artifact.getArtifactId())) continue;
            versions.add(foundArtifact.getBaseVersion());
        }
        return new ArrayList<String>(versions);
    }

    private Set<String> getClassPathEntries(String classPath) {
        if (classPath == null || classPath.isEmpty()) {
            return Collections.emptySet();
        }
        return new LinkedHashSet<String>(Arrays.asList(classPath.split(File.pathSeparator)));
    }

    private File getClasspathFile(String classpathEntry) {
        File classpathFileInfo = this.classpathFileInfoCache.get(classpathEntry);
        if (classpathFileInfo == null) {
            classpathFileInfo = new File(classpathEntry);
            this.classpathFileInfoCache.put(classpathEntry, classpathFileInfo);
        }
        return classpathFileInfo;
    }

    private File getPomFile(File childFile) {
        File pomFileInfo = this.pomFileInfoCache.get(childFile);
        if (pomFileInfo == null) {
            pomFileInfo = new File(childFile.getParentFile().getParentFile(), "pom.xml");
            this.pomFileInfoCache.put(childFile, pomFileInfo);
        }
        return pomFileInfo;
    }

    private Artifact getFoundArtifact(File pomFile) {
        Artifact foundArtifact = this.foundArtifactCache.get(pomFile);
        if (foundArtifact == null) {
            foundArtifact = this.createFoundArtifact(pomFile);
            this.foundArtifactCache.put(pomFile, foundArtifact);
        }
        return foundArtifact;
    }

    private Artifact createFoundArtifact(File pomFile) {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing " + pomFile.getAbsolutePath() + " for classpath artifact resolution");
            }
            Node pom = XMLParser.parse((File)pomFile);
            String groupId = pom.getTextValueForPatternName("groupId");
            String artifactId = pom.getTextValueForPatternName("artifactId");
            String type = pom.getTextValueForPatternName("packaging");
            String version = pom.getTextValueForPatternName("version");
            if (groupId == null || groupId.isEmpty()) {
                groupId = pom.getTextValueForPatternName("parent/groupId");
            }
            if (type == null || type.isEmpty()) {
                type = "jar";
            }
            if (version == null || version.isEmpty()) {
                version = pom.getTextValueForPatternName("parent/version");
            }
            DefaultArtifact foundArtifact = new DefaultArtifact(groupId, artifactId, type, version);
            foundArtifact.setFile(pomFile);
            return foundArtifact;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse pom.xml: " + pomFile, e);
        }
    }
}

