/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.jboss.forge.furnace.manager.maven.MavenContainer;

public class MavenRepositories {
    private static final String MAVEN_CENTRAL_REPO = "http://repo1.maven.org/maven2";

    public static List<RemoteRepository> getRemoteRepositories(MavenContainer container, Settings settings) {
        ArrayList<RemoteRepository> remoteRepos = new ArrayList<RemoteRepository>();
        remoteRepos.addAll(container.getEnabledRepositoriesFromProfile(settings));
        if (remoteRepos.isEmpty()) {
            remoteRepos.add(MavenRepositories.convertToMavenRepo("central", MAVEN_CENTRAL_REPO, settings));
        }
        return remoteRepos;
    }

    static RemoteRepository convertToMavenRepo(String id, String url, Settings settings) {
        RemoteRepository.Builder remoteRepositoryBuilder = new RemoteRepository.Builder(id, "default", url);
        org.apache.maven.settings.Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy != null) {
            Authentication auth = new AuthenticationBuilder().addUsername(activeProxy.getUsername()).addPassword(activeProxy.getPassword()).build();
            remoteRepositoryBuilder.setProxy(new Proxy(activeProxy.getProtocol(), activeProxy.getHost(), activeProxy.getPort(), auth));
        }
        return remoteRepositoryBuilder.build();
    }
}

