/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.wagon.WagonProvider;
import org.eclipse.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.jboss.forge.furnace.manager.maven.ClasspathWorkspaceReader;
import org.jboss.forge.furnace.manager.maven.LazyAuthenticationSelector;
import org.jboss.forge.furnace.manager.maven.LogTransferListener;
import org.jboss.forge.furnace.manager.maven.ManualWagonProvider;

public class MavenContainer {
    private static final String M2_HOME = System.getenv().get("M2_HOME");
    public static final String ALT_USER_SETTINGS_XML_LOCATION = "org.apache.maven.user-settings";
    public static final String ALT_GLOBAL_SETTINGS_XML_LOCATION = "org.apache.maven.global-settings";
    public static final String ALT_LOCAL_REPOSITORY_LOCATION = "maven.repo.local";

    public List<RemoteRepository> getEnabledRepositoriesFromProfile(Settings settings) {
        ArrayList<RemoteRepository> settingsRepos = new ArrayList<RemoteRepository>();
        List activeProfiles = settings.getActiveProfiles();
        for (Profile profile : settings.getProfiles()) {
            Activation activation = profile.getActivation();
            if (activation == null || !activation.isActiveByDefault()) continue;
            activeProfiles.add(profile.getId());
        }
        Map profiles = settings.getProfilesAsMap();
        for (String id : activeProfiles) {
            Profile profile = (Profile)profiles.get(id);
            if (profile == null) continue;
            List repositories = profile.getRepositories();
            for (Repository repository : repositories) {
                settingsRepos.add(new RemoteRepository.Builder(repository.getId(), repository.getLayout(), repository.getUrl()).build());
            }
        }
        return settingsRepos;
    }

    public Settings getSettings() {
        try {
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
            String userSettingsLocation = System.getProperty(ALT_USER_SETTINGS_XML_LOCATION);
            if (userSettingsLocation != null) {
                settingsRequest.setUserSettingsFile(new File(userSettingsLocation));
            } else {
                settingsRequest.setUserSettingsFile(new File(this.getUserHomeDir(), "/.m2/settings.xml"));
            }
            String globalSettingsLocation = System.getProperty(ALT_GLOBAL_SETTINGS_XML_LOCATION);
            if (globalSettingsLocation != null) {
                settingsRequest.setGlobalSettingsFile(new File(globalSettingsLocation));
            } else if (M2_HOME != null) {
                settingsRequest.setGlobalSettingsFile(new File(M2_HOME, "/conf/settings.xml"));
            }
            SettingsBuildingResult settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
            Settings effectiveSettings = settingsBuildingResult.getEffectiveSettings();
            if (effectiveSettings.getLocalRepository() == null) {
                String userRepositoryLocation = System.getProperty(ALT_LOCAL_REPOSITORY_LOCATION);
                if (userRepositoryLocation != null) {
                    effectiveSettings.setLocalRepository(userRepositoryLocation);
                } else {
                    effectiveSettings.setLocalRepository(this.getUserHomePath() + "/.m2/repository");
                }
            }
            return effectiveSettings;
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e);
        }
    }

    public RepositorySystem getRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new DefaultModelBuilderFactory().newInstance()});
        locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
        locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
        RepositorySystem repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        return repositorySystem;
    }

    public static Proxy convertFromMavenProxy(org.apache.maven.settings.Proxy proxy) {
        Proxy result = null;
        if (proxy != null) {
            Authentication auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
            result = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
        }
        return result;
    }

    private File getUserHomeDir() {
        return new File(System.getProperty("user.home")).getAbsoluteFile();
    }

    private String getUserHomePath() {
        return this.getUserHomeDir().getAbsolutePath();
    }

    public DefaultRepositorySystemSession setupRepoSession(RepositorySystem repoSystem, Settings settings) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setOffline(false);
        org.apache.maven.settings.Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy != null) {
            DefaultProxySelector dps = new DefaultProxySelector();
            dps.add(MavenContainer.convertFromMavenProxy(activeProxy), activeProxy.getNonProxyHosts());
            session.setProxySelector((ProxySelector)dps);
        }
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        List mirrors = settings.getMirrors();
        if (mirrors != null) {
            for (Mirror mirror : mirrors) {
                mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
            }
            session.setMirrorSelector((MirrorSelector)mirrorSelector);
        }
        LazyAuthenticationSelector authSelector = new LazyAuthenticationSelector(mirrorSelector);
        for (Server server : settings.getServers()) {
            authSelector.add(server.getId(), new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).addPrivateKey(server.getPrivateKey(), server.getPassphrase()).build());
        }
        session.setAuthenticationSelector((AuthenticationSelector)authSelector);
        LocalRepository localRepo = new LocalRepository(new File(settings.getLocalRepository()));
        session.setLocalRepositoryManager(repoSystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setChecksumPolicy("ignore");
        session.setCache((RepositoryCache)new DefaultRepositoryCache());
        boolean cacheNotFoundArtifacts = true;
        boolean cacheTransferErrors = true;
        session.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(cacheNotFoundArtifacts, cacheTransferErrors));
        session.setWorkspaceReader((WorkspaceReader)new ClasspathWorkspaceReader());
        session.setTransferListener((TransferListener)new LogTransferListener(System.out));
        return session;
    }
}

