/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.manager.maven.addon;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.manager.maven.MavenContainer;
import org.jboss.forge.furnace.manager.maven.addon.AddonDependencySelector;
import org.jboss.forge.furnace.manager.maven.addon.AddonDependencyTraverser;
import org.jboss.forge.furnace.manager.maven.addon.AddonInfoBuilder;
import org.jboss.forge.furnace.manager.maven.addon.LazyAddonInfo;
import org.jboss.forge.furnace.manager.maven.result.MavenResponseBuilder;
import org.jboss.forge.furnace.manager.maven.util.MavenRepositories;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.manager.spi.AddonInfo;
import org.jboss.forge.furnace.manager.spi.Response;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Versions;

public class MavenAddonDependencyResolver
implements AddonDependencyResolver {
    private static final String FURNACE_API_GROUP_ID = "org.jboss.forge.furnace";
    private static final String FURNACE_CONTAINER_GROUP_ID = "org.jboss.forge.furnace.container";
    private static final String FURNACE_API_ARTIFACT_ID = "furnace-api";
    public static final String FORGE_ADDON_CLASSIFIER = "forge-addon";
    private final String classifier;
    private Settings settings;
    private boolean resolveAddonAPIVersions = true;
    private final MavenContainer container = new MavenContainer();

    public MavenAddonDependencyResolver() {
        this.classifier = FORGE_ADDON_CLASSIFIER;
    }

    public MavenAddonDependencyResolver(String classifier) {
        Assert.notNull((Object)classifier, (String)"Classifier should not be null");
        this.classifier = classifier;
    }

    public AddonInfo resolveAddonDependencyHierarchy(AddonId addonId) {
        AddonInfoBuilder builder = AddonInfoBuilder.from(addonId);
        try {
            ArtifactDescriptorResult result = this.readArtifactDescriptor(addonId);
            AddonId furnaceContainerId = null;
            for (Dependency dependency : result.getDependencies()) {
                String scope = dependency.getScope();
                if ("test".equals(scope)) continue;
                Artifact artifact = dependency.getArtifact();
                if (this.isFurnaceAPI(artifact)) {
                    SingleVersion apiVersion = SingleVersion.valueOf((String)artifact.getBaseVersion());
                    builder.setAPIVersion((org.jboss.forge.furnace.versions.Version)apiVersion);
                    continue;
                }
                if (!this.isAddon(artifact)) continue;
                AddonId childId = this.toAddonId(artifact);
                if (MavenAddonDependencyResolver.isFurnaceContainer(artifact)) {
                    furnaceContainerId = childId;
                }
                boolean exported = MavenAddonDependencyResolver.isExported(scope);
                boolean optional = dependency.isOptional();
                if (optional) {
                    builder.addOptionalDependency(childId, exported);
                    continue;
                }
                builder.addRequiredDependency(childId, exported);
            }
            org.jboss.forge.furnace.versions.Version addonAPIVersion = builder.getAddon().getApiVersion();
            if (this.resolveAddonAPIVersions && (addonAPIVersion == null || EmptyVersion.getInstance().equals(addonAPIVersion))) {
                String apiVersion = null;
                if (furnaceContainerId != null) {
                    ArtifactDescriptorResult containerDescriptor = this.readArtifactDescriptor(furnaceContainerId);
                    apiVersion = this.findDependencyVersion(containerDescriptor.getDependencies(), FURNACE_API_GROUP_ID, FURNACE_API_ARTIFACT_ID);
                } else {
                    apiVersion = (String)this.resolveAPIVersion(addonId).get();
                }
                if (apiVersion != null) {
                    builder.setAPIVersion((org.jboss.forge.furnace.versions.Version)SingleVersion.valueOf((String)apiVersion));
                }
            }
        }
        catch (ArtifactDescriptorException e) {
            throw new RuntimeException("Error while retrieving addon information for " + addonId, e);
        }
        return new LazyAddonInfo(this, builder);
    }

    public Response<File[]> resolveResources(AddonId addonId) {
        DependencyResult result;
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.getSettings();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        String mavenCoords = this.toMavenCoords(addonId);
        DefaultArtifact queryArtifact = new DefaultArtifact(mavenCoords);
        session.setDependencyTraverser((DependencyTraverser)new AddonDependencyTraverser(this.classifier));
        session.setDependencySelector((DependencySelector)new AddonDependencySelector(this.classifier));
        Dependency dependency = new Dependency((Artifact)queryArtifact, null);
        List<RemoteRepository> repositories = MavenRepositories.getRemoteRepositories(this.container, settings);
        CollectRequest collectRequest = new CollectRequest(dependency, repositories);
        try {
            result = system.resolveDependencies((RepositorySystemSession)session, new DependencyRequest(collectRequest, null));
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException(e);
        }
        List collectExceptions = result.getCollectExceptions();
        HashSet<File> files = new HashSet<File>();
        List artifactResults = result.getArtifactResults();
        for (ArtifactResult artifactResult : artifactResults) {
            Artifact artifact = artifactResult.getArtifact();
            if (this.isFurnaceAPI(artifact) || this.classifier.equals(artifact.getClassifier()) && !addonId.getName().equals(artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
            files.add(artifact.getFile());
        }
        return new MavenResponseBuilder<File[]>(files.toArray(new File[files.size()])).setExceptions(collectExceptions);
    }

    public Response<AddonId[]> resolveVersions(String addonName) {
        String version;
        String addonNameSplit;
        String[] split = addonName.split(",");
        if (split.length == 2) {
            addonNameSplit = split[0];
            version = split[1];
        } else {
            addonNameSplit = addonName;
            version = null;
        }
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.getSettings();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        List<RemoteRepository> repositories = MavenRepositories.getRemoteRepositories(this.container, settings);
        VersionRangeResult versions = this.getVersions(system, settings, (RepositorySystemSession)session, repositories, addonNameSplit, version);
        List exceptions = versions.getExceptions();
        List versionsList = versions.getVersions();
        ArrayList<AddonId> addons = new ArrayList<AddonId>();
        ArrayList<AddonId> snapshots = new ArrayList<AddonId>();
        for (Version artifactVersion : versionsList) {
            AddonId addonId = AddonId.from((String)addonName, (String)artifactVersion.toString());
            if (Versions.isSnapshot((org.jboss.forge.furnace.versions.Version)addonId.getVersion())) {
                snapshots.add(addonId);
                continue;
            }
            addons.add(addonId);
        }
        if (addons.isEmpty()) {
            addons = snapshots;
        }
        return new MavenResponseBuilder<AddonId[]>(addons.toArray(new AddonId[addons.size()])).setExceptions(exceptions);
    }

    public Response<String> resolveAPIVersion(AddonId addonId) {
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.getSettings();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        return this.resolveAPIVersion(addonId, system, settings, session);
    }

    private Response<String> resolveAPIVersion(AddonId addonId, RepositorySystem system, Settings settings, DefaultRepositorySystemSession session) {
        CollectResult result;
        List<RemoteRepository> repositories = MavenRepositories.getRemoteRepositories(this.container, settings);
        String mavenCoords = this.toMavenCoords(addonId);
        DefaultArtifact queryArtifact = new DefaultArtifact(mavenCoords);
        session.setDependencyTraverser((DependencyTraverser)new AddonDependencyTraverser(this.classifier));
        session.setDependencySelector(new DependencySelector(){

            public boolean selectDependency(Dependency dependency) {
                Artifact artifact = dependency.getArtifact();
                if (MavenAddonDependencyResolver.this.isAddon(artifact)) {
                    return true;
                }
                return MavenAddonDependencyResolver.this.isFurnaceAPI(artifact);
            }

            public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
                return this;
            }
        });
        CollectRequest request = new CollectRequest(new Dependency((Artifact)queryArtifact, null), repositories);
        try {
            result = system.collectDependencies((RepositorySystemSession)session, request);
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(e);
        }
        List exceptions = result.getExceptions();
        String apiVersion = this.findVersion(result.getRoot().getChildren(), FURNACE_API_GROUP_ID, FURNACE_API_ARTIFACT_ID);
        return new MavenResponseBuilder<String>(apiVersion).setExceptions(exceptions);
    }

    private ArtifactDescriptorResult readArtifactDescriptor(AddonId addonId) throws ArtifactDescriptorException {
        String coords = this.toMavenCoords(addonId);
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.getSettings();
        DefaultRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        List<RemoteRepository> repositories = MavenRepositories.getRemoteRepositories(this.container, settings);
        ArtifactDescriptorRequest request = new ArtifactDescriptorRequest();
        request.setArtifact((Artifact)new DefaultArtifact(coords));
        request.setRepositories(repositories);
        ArtifactDescriptorResult result = system.readArtifactDescriptor((RepositorySystemSession)session, request);
        return result;
    }

    private String findDependencyVersion(List<Dependency> dependencies, String groupId, String artifactId) {
        for (Dependency child : dependencies) {
            Artifact childArtifact = child.getArtifact();
            if (!groupId.equals(childArtifact.getGroupId()) || !artifactId.equals(childArtifact.getArtifactId())) continue;
            return childArtifact.getBaseVersion();
        }
        return null;
    }

    private String findVersion(List<DependencyNode> dependencies, String groupId, String artifactId) {
        for (DependencyNode child : dependencies) {
            Artifact childArtifact = child.getArtifact();
            if (groupId.equals(childArtifact.getGroupId()) && artifactId.equals(childArtifact.getArtifactId())) {
                return childArtifact.getBaseVersion();
            }
            String version = this.findVersion(child.getChildren(), groupId, artifactId);
            if (version == null) continue;
            return version;
        }
        return null;
    }

    private VersionRangeResult getVersions(RepositorySystem system, Settings settings, RepositorySystemSession session, List<RemoteRepository> repositories, String addonName, String version) {
        try {
            String[] split = addonName.split(",");
            if (split.length == 2) {
                version = split[1];
            }
            if (version == null || version.isEmpty()) {
                version = "[,)";
            } else if (!version.matches("(\\(|\\[).*?(\\)|\\])")) {
                version = "[" + version + "]";
            }
            DefaultArtifact artifact = new DefaultArtifact(this.toMavenCoords(AddonId.from((String)addonName, (String)version)));
            VersionRangeRequest rangeRequest = new VersionRangeRequest((Artifact)artifact, repositories, null);
            VersionRangeResult rangeResult = system.resolveVersionRange(session, rangeRequest);
            return rangeResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to look up versions for [" + addonName + "]", e);
        }
    }

    private String toMavenCoords(AddonId addonId) {
        String coords = addonId.getName() + ":jar:" + this.classifier + ":" + addonId.getVersion();
        return coords;
    }

    private boolean isAddon(Artifact artifact) {
        return this.classifier.equals(artifact.getClassifier());
    }

    private AddonId toAddonId(Artifact artifact) {
        if (this.isAddon(artifact)) {
            return AddonId.from((String)(artifact.getGroupId() + ":" + artifact.getArtifactId()), (String)artifact.getBaseVersion());
        }
        throw new IllegalArgumentException("Not a forge-addon: " + artifact);
    }

    private boolean isFurnaceAPI(Artifact artifact) {
        return FURNACE_API_GROUP_ID.equals(artifact.getGroupId()) && FURNACE_API_ARTIFACT_ID.equals(artifact.getArtifactId());
    }

    public static boolean isExported(String scope) {
        String artifactScope;
        switch (artifactScope = Strings.isNullOrEmpty((String)scope) ? "compile" : scope) {
            case "compile": 
            case "runtime": {
                return true;
            }
        }
        return false;
    }

    public static boolean isFurnaceContainer(Artifact artifact) {
        return FURNACE_CONTAINER_GROUP_ID.equals(artifact.getGroupId());
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings == null ? this.container.getSettings() : this.settings;
    }

    public void setResolveAddonAPIVersions(boolean resolveAddonAPIVersions) {
        this.resolveAddonAPIVersions = resolveAddonAPIVersions;
    }

    public boolean isResolveAddonAPIVersions() {
        return this.resolveAddonAPIVersions;
    }
}

