/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.maven.plugin;

import java.io.File;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.impl.FurnaceImpl;
import org.jboss.forge.furnace.manager.impl.AddonManagerImpl;
import org.jboss.forge.furnace.manager.request.InstallRequest;
import org.jboss.forge.furnace.manager.spi.AddonDependencyResolver;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;

@Mojo(name="addon-install", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class AddonInstallMojo
extends AbstractMojo {
    @Parameter(property="forge.repository", required=true)
    private File addonRepository;
    @Parameter(property="forge.addonIds", required=true)
    private String[] addonIds;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FurnaceImpl forge = new FurnaceImpl();
        if (!this.addonRepository.exists()) {
            this.addonRepository.mkdirs();
        }
        AddonRepository repository = forge.addRepository(AddonRepositoryMode.MUTABLE, this.addonRepository);
        Iterator<AddonDependencyResolver> it = ServiceLoader.load(AddonDependencyResolver.class).iterator();
        if (!it.hasNext()) {
            throw new MojoExecutionException("No AddonDependencyResolver implementation found. Please add one in the <dependencies> section of the forge-maven-plugin.");
        }
        AddonDependencyResolver addonResolver = it.next();
        AddonManagerImpl addonManager = new AddonManagerImpl((Furnace)forge, addonResolver, false);
        for (String addonId : this.addonIds) {
            AddonId id = AddonId.fromCoordinates((String)addonId);
            InstallRequest install = addonManager.install(id, repository);
            if (install.getActions().isEmpty()) continue;
            this.getLog().info((CharSequence)("" + install));
            install.perform();
        }
    }
}

