/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ClassLoaderInterceptor
implements ForgeProxy {
    private ClassLoader loader;
    private Object delegate;

    public ClassLoaderInterceptor(ClassLoader loader, Object delegate) {
        this.loader = loader;
        this.delegate = delegate;
    }

    public Object invoke(Object self, final Method thisMethod, Method proceed, final Object[] args) throws Throwable {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object result;
                try {
                    if (thisMethod.getDeclaringClass().getName().equals(ForgeProxy.class.getName())) {
                        return ClassLoaderInterceptor.this.delegate;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    result = thisMethod.invoke(ClassLoaderInterceptor.this.delegate, args);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw (Exception)e.getCause();
                    }
                    throw e;
                }
                return result;
            }
        };
        return ClassLoaders.executeIn((ClassLoader)this.loader, (Callable)task);
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }
}

