/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.proxy;

import java.lang.reflect.Method;
import java.util.Collection;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.jboss.forge.furnace.proxy.Arrays;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.proxy.ProxyTypeInspector;

public class Proxies {
    public static <T> T enhance(final ClassLoader loader, Object instance, ForgeProxy handler) {
        int index;
        MethodFilter filter = new MethodFilter(){

            public boolean isHandled(Method method) {
                String name = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                return !method.getDeclaringClass().getName().contains("java.lang") || "clone".equals(name) && parameterTypes.length == 0 || "equals".equals(name) && parameterTypes.length == 1 || "hashCode".equals(name) && parameterTypes.length == 0 || "toString".equals(name) && parameterTypes.length == 0;
            }
        };
        T enhancedResult = null;
        ProxyFactory f = new ProxyFactory(){

            protected ClassLoader getClassLoader() {
                return loader;
            }
        };
        f.setUseCache(true);
        Class[] hierarchy = null;
        Class<?> unwrappedInstanceType = Proxies.unwrapProxyTypes(instance.getClass(), loader);
        hierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(loader, unwrappedInstanceType);
        if (hierarchy == null || hierarchy.length == 0) {
            throw new IllegalArgumentException("Must specify at least one non-final type to enhance for Object: " + instance + " of type " + instance.getClass());
        }
        Class<?> first = hierarchy[0];
        if (!first.isInterface()) {
            f.setSuperclass(Proxies.unwrapProxyTypes(first, loader));
            hierarchy = Arrays.shiftLeft(hierarchy, new Class[hierarchy.length - 1]);
        }
        if ((index = Arrays.indexOf(hierarchy, ProxyObject.class)) >= 0) {
            hierarchy = Arrays.removeElementAtIndex(hierarchy, index);
        }
        if (!Proxies.isProxyType(first) && !Arrays.contains(hierarchy, ForgeProxy.class)) {
            hierarchy = Arrays.append(hierarchy, ForgeProxy.class);
        }
        if (hierarchy.length > 0) {
            f.setInterfaces(hierarchy);
        }
        f.setFilter(filter);
        Class c = f.createClass();
        try {
            enhancedResult = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate proxy for object [" + instance + "] of type [" + unwrappedInstanceType + "]. For optimal proxy compatability, ensure " + "that this type is an interface, or a class with a default constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        ((ProxyObject)enhancedResult).setHandler((MethodHandler)handler);
        return enhancedResult;
    }

    public static <T> T enhance(Class<T> type, ForgeProxy handler) {
        MethodFilter filter = new MethodFilter(){

            public boolean isHandled(Method method) {
                String name = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                return !method.getDeclaringClass().getName().contains("java.lang") || "clone".equals(name) && parameterTypes.length == 0 || "equals".equals(name) && parameterTypes.length == 1 || "hashCode".equals(name) && parameterTypes.length == 0 || "toString".equals(name) && parameterTypes.length == 0;
            }
        };
        T enhancedResult = null;
        ProxyFactory f = new ProxyFactory();
        f.setUseCache(true);
        if (type.isInterface() && !ForgeProxy.class.isAssignableFrom(type)) {
            f.setInterfaces(new Class[]{type, ForgeProxy.class});
        } else if (type.isInterface()) {
            f.setInterfaces(new Class[]{type});
        } else if (Proxies.isProxyType(type)) {
            f.setSuperclass(Proxies.unwrapProxyTypes(type, new ClassLoader[0]));
        } else {
            f.setSuperclass(type);
            f.setInterfaces(new Class[]{ForgeProxy.class});
        }
        f.setFilter(filter);
        Class c = f.createClass();
        try {
            enhancedResult = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not instantiate proxy for type [" + type + "]. For optimal proxy compatability, ensure " + "that this type is an interface, or a class with a default constructor.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        ((ProxyObject)enhancedResult).setHandler((MethodHandler)handler);
        return enhancedResult;
    }

    public static boolean isProxyType(Class<?> type) {
        return type.getName().contains("$$EnhancerByCGLIB$$") || type.getName().contains("_javassist_") || type.getName().contains("$Proxy$_$$_WeldClientProxy");
    }

    public static <T> T unwrap(Object object) {
        Object result = object;
        if (object != null) {
            while (Proxies.isForgeProxy(result)) {
                try {
                    Method method = result.getClass().getMethod("getDelegate", new Class[0]);
                    method.setAccessible(true);
                    result = method.invoke(result, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                    break;
                }
            }
            if (result == null) {
                result = object;
            }
        }
        return (T)result;
    }

    public static <T> T unwrapOnce(Object object) {
        Object result = object;
        if (object != null) {
            if (Proxies.isForgeProxy(result)) {
                try {
                    Method method = result.getClass().getMethod("getDelegate", new Class[0]);
                    method.setAccessible(true);
                    result = method.invoke(result, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (result == null) {
                result = object;
            }
        }
        return (T)result;
    }

    public static boolean isForgeProxy(Object object) {
        Class<?>[] interfaces;
        if (object != null && (interfaces = object.getClass().getInterfaces()) != null) {
            for (Class<?> iface : interfaces) {
                if (!iface.getName().equals(ForgeProxy.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static Class<?> unwrapProxyTypes(Class<?> type, ClassLoader ... loaders) {
        Class<?> result = type;
        if (Proxies.isProxyType(result)) {
            Class<?> superclass;
            for (superclass = result.getSuperclass(); superclass != null && !superclass.getName().equals(Object.class.getName()) && Proxies.isProxyType(superclass); superclass = superclass.getSuperclass()) {
            }
            if (superclass != null && !superclass.getName().equals(Object.class.getName())) {
                return superclass;
            }
            String typeName = Proxies.unwrapProxyClassName(result);
            for (ClassLoader loader : loaders) {
                try {
                    result = loader.loadClass(typeName);
                    break;
                }
                catch (ClassNotFoundException e) {
                }
            }
        }
        return result;
    }

    public static String unwrapProxyClassName(Class<?> type) {
        String typeName = type.getName().contains("$$EnhancerByCGLIB$$") ? type.getName().replaceAll("^(.*)\\$\\$EnhancerByCGLIB\\$\\$.*", "$1") : (type.getName().contains("_javassist_") ? type.getName().replaceAll("^(.*)_\\$\\$_javassist_.*", "$1") : type.getName());
        return typeName;
    }

    public static boolean areEquivalent(Object proxiedObj, Object anotherProxiedObj) {
        if (proxiedObj == null && anotherProxiedObj == null) {
            return true;
        }
        if (proxiedObj == null || anotherProxiedObj == null) {
            return false;
        }
        Object unproxiedObj = Proxies.unwrap(proxiedObj);
        Object anotherUnproxiedObj = Proxies.unwrap(anotherProxiedObj);
        boolean sameClassName = Proxies.unwrapProxyClassName(unproxiedObj.getClass()).equals(Proxies.unwrapProxyClassName(anotherUnproxiedObj.getClass()));
        if (sameClassName) {
            if (unproxiedObj.getClass().isEnum()) {
                Enum enumLeft = (Enum)Enum.class.cast(unproxiedObj);
                Enum enumRight = (Enum)Enum.class.cast(anotherUnproxiedObj);
                return enumLeft.name().equals(enumRight.name()) && enumLeft.ordinal() == enumRight.ordinal();
            }
            return unproxiedObj.hashCode() == anotherUnproxiedObj.hashCode();
        }
        return false;
    }

    public static boolean isInstance(Class<?> type, Object proxiedObject) {
        return type.isInstance(Proxies.unwrap(proxiedObject));
    }

    public static boolean isInstantiable(Class<?> type) {
        if (type != null) {
            try {
                if (type.isInterface()) {
                    return true;
                }
                type.getConstructor(new Class[0]);
                return true;
            }
            catch (SecurityException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isPassthroughType(Class<?> type) {
        boolean result = type.isArray() || type.getName().matches("^(java\\.lang).*") || type.getName().matches("^(java\\.io).*") || type.getName().matches("^(java\\.net).*") || type.isPrimitive();
        result = result && !Iterable.class.getName().equals(type.getName());
        return result;
    }

    public static boolean isLanguageType(Class<?> type) {
        boolean result = type.isArray() || type.getName().matches("^(java\\.).*") || type.isPrimitive();
        return result;
    }

    public static boolean isCollectionType(Object instance) {
        boolean result = instance instanceof Collection || instance instanceof Iterable || instance.getClass().isArray();
        return result;
    }
}

