/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.proxy.Arrays;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.proxy.ProxyTypeInspector;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ClassLoaderAdapterCallback
implements MethodHandler,
ForgeProxy {
    private static final Logger log = Logger.getLogger(ClassLoaderAdapterCallback.class.getName());
    private static final ClassLoader JAVASSIST_LOADER = ProxyObject.class.getClassLoader();
    private final Object delegate;
    private final ClassLoader callingLoader;
    private final ClassLoader delegateLoader;
    private final Object unwrappedDelegate;
    private final Class<?> unwrappedDelegateType;
    private final ClassLoader unwrappedDelegateLoader;

    public ClassLoaderAdapterCallback(ClassLoader callingLoader, ClassLoader delegateLoader, Object delegate) {
        Assert.notNull((Object)callingLoader, (String)"Calling loader must not be null.");
        Assert.notNull((Object)delegateLoader, (String)"Delegate loader must not be null.");
        Assert.notNull((Object)delegate, (String)"Delegate must not be null.");
        this.callingLoader = callingLoader;
        this.delegateLoader = delegateLoader;
        this.delegate = delegate;
        this.unwrappedDelegate = Proxies.unwrap(delegate);
        this.unwrappedDelegateType = Proxies.unwrapProxyTypes(this.unwrappedDelegate.getClass(), callingLoader, delegateLoader, this.unwrappedDelegate.getClass().getClassLoader());
        this.unwrappedDelegateLoader = this.unwrappedDelegateType.getClassLoader();
    }

    public Object invoke(Object obj, final Method thisMethod, Method proceed, final Object[] args) throws Throwable {
        return ClassLoaders.executeIn((ClassLoader)this.delegateLoader, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (thisMethod.getDeclaringClass().equals(ClassLoaderAdapterCallback.this.callingLoader.loadClass(ForgeProxy.class.getName()))) {
                        return ClassLoaderAdapterCallback.this.delegate;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                Method delegateMethod = this.getDelegateMethod(thisMethod);
                List parameterValues = ClassLoaderAdapterCallback.this.enhanceParameterValues(args, delegateMethod);
                AccessibleObject.setAccessible(new AccessibleObject[]{delegateMethod}, true);
                try {
                    Object[] parameterValueArray = parameterValues.toArray();
                    Object result = delegateMethod.invoke(ClassLoaderAdapterCallback.this.delegate, parameterValueArray);
                    return ClassLoaderAdapterCallback.this.enhanceResult(thisMethod, result);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw ClassLoaderAdapterCallback.this.enhanceException(delegateMethod, (Exception)e.getCause());
                    }
                    throw ClassLoaderAdapterCallback.this.enhanceException(delegateMethod, e);
                }
            }

            private Method getDelegateMethod(Method proxy) throws ClassNotFoundException, NoSuchMethodException {
                Method delegateMethod;
                block4: {
                    delegateMethod = null;
                    try {
                        List parameterTypes = ClassLoaderAdapterCallback.this.translateParameterTypes(proxy);
                        delegateMethod = ClassLoaderAdapterCallback.this.delegate.getClass().getMethod(proxy.getName(), parameterTypes.toArray(new Class[parameterTypes.size()]));
                    }
                    catch (ClassNotFoundException e) {
                        block2: for (Method m : ClassLoaderAdapterCallback.this.delegate.getClass().getMethods()) {
                            Class<?>[] delegateParameterTypes;
                            Class<?>[] methodParameterTypes;
                            String delegateMethodName;
                            String methodName = proxy.getName();
                            if (!methodName.equals(delegateMethodName = m.getName()) || (methodParameterTypes = proxy.getParameterTypes()).length != (delegateParameterTypes = m.getParameterTypes()).length) continue;
                            for (int i = 0; i < methodParameterTypes.length; ++i) {
                                Class<?> methodType = methodParameterTypes[i];
                                Class<?> delegateType = delegateParameterTypes[i];
                                if (!methodType.getName().equals(delegateType.getName())) continue block2;
                            }
                            delegateMethod = m;
                            break;
                        }
                        if (delegateMethod != null) break block4;
                        throw e;
                    }
                }
                return delegateMethod;
            }
        });
    }

    private Object enhanceResult(Method method, Object result) {
        if (result != null) {
            Class<?> returnType;
            Object unwrappedResult = Proxies.unwrap(result);
            Class<?> unwrappedResultType = unwrappedResult.getClass();
            ClassLoader resultInstanceLoader = this.delegateLoader;
            if (!ClassLoaders.containsClass((ClassLoader)this.delegateLoader, unwrappedResultType) && (resultInstanceLoader = Proxies.unwrapProxyTypes(unwrappedResultType, this.callingLoader, this.delegateLoader, unwrappedResultType.getClassLoader()).getClassLoader()) == null) {
                resultInstanceLoader = this.getClass().getClassLoader();
            }
            if (this.returnTypeNeedsEnhancement(returnType = method.getReturnType(), result, unwrappedResultType)) {
                Class<?>[] resultHierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(this.callingLoader, Proxies.unwrapProxyTypes(result.getClass(), this.callingLoader, this.delegateLoader, resultInstanceLoader));
                Class<?>[] returnTypeHierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(this.callingLoader, Proxies.unwrapProxyTypes(returnType, this.callingLoader, this.delegateLoader, resultInstanceLoader));
                if (!Modifier.isFinal(returnType.getModifiers())) {
                    if (Object.class.equals(returnType) && !Object.class.equals(result)) {
                        result = ClassLoaderAdapterCallback.enhance(this.callingLoader, resultInstanceLoader, method, result, resultHierarchy);
                    } else {
                        if (returnTypeHierarchy.length == 0) {
                            returnTypeHierarchy = new Class[]{returnType};
                        }
                        result = ClassLoaderAdapterCallback.enhance(this.callingLoader, resultInstanceLoader, method, result, this.mergeHierarchies(returnTypeHierarchy, resultHierarchy));
                    }
                } else {
                    result = result.getClass().isEnum() ? this.enhanceEnum(this.callingLoader, result) : ClassLoaderAdapterCallback.enhance(this.callingLoader, resultInstanceLoader, (Object)method, returnTypeHierarchy);
                }
            }
        }
        return result;
    }

    private Exception enhanceException(Method method, Exception exception) {
        Exception result = exception;
        try {
            if (exception != null) {
                Exception unwrappedException = (Exception)Proxies.unwrap(exception);
                Class<?> unwrappedExceptionType = unwrappedException.getClass();
                ClassLoader exceptionLoader = this.delegateLoader;
                if (!ClassLoaders.containsClass((ClassLoader)this.delegateLoader, unwrappedExceptionType) && (exceptionLoader = Proxies.unwrapProxyTypes(unwrappedExceptionType, this.callingLoader, this.delegateLoader, unwrappedExceptionType.getClassLoader()).getClassLoader()) == null) {
                    exceptionLoader = this.getClass().getClassLoader();
                }
                if (this.exceptionNeedsEnhancement(exception)) {
                    Class<?>[] exceptionHierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(this.callingLoader, Proxies.unwrapProxyTypes(exception.getClass(), this.callingLoader, this.delegateLoader, exceptionLoader));
                    if (!Modifier.isFinal(unwrappedExceptionType.getModifiers())) {
                        result = (Exception)ClassLoaderAdapterCallback.enhance(this.callingLoader, exceptionLoader, method, exception, exceptionHierarchy);
                        result.initCause(exception);
                        result.setStackTrace(exception.getStackTrace());
                    }
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not enhance exception for passing through ClassLoader boundary. Exception type [" + exception.getClass().getName() + "], Caller [" + this.callingLoader + "], Delegate [" + this.delegateLoader + "]");
            return exception;
        }
        return result;
    }

    private Object enhanceEnum(ClassLoader loader, Object instance) {
        try {
            Class<?> callingType = loader.loadClass(instance.getClass().getName());
            return Enum.valueOf(callingType, ((Enum)instance).name());
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException("Could not enhance instance [" + instance + "] of type [" + instance.getClass() + "]", (Throwable)e);
        }
    }

    private Class<?>[] mergeHierarchies(Class<?>[] left, Class<?>[] right) {
        for (Class<?> type : right) {
            boolean found = false;
            for (Class<?> existing : left) {
                if (!type.equals(existing)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (type.isInterface()) {
                left = Arrays.append(left, type);
                continue;
            }
            if (left.length != 0 && !left[0].isInterface()) continue;
            left = Arrays.prepend(left, type);
        }
        return left;
    }

    private boolean exceptionNeedsEnhancement(Exception exception) {
        Class<?> exceptionType = exception.getClass();
        Class<?> unwrappedExceptionType = Proxies.unwrap(exception).getClass();
        if (Proxies.isPassthroughType(unwrappedExceptionType)) {
            return false;
        }
        return unwrappedExceptionType.getClassLoader() == null || exceptionType.getClassLoader().equals(this.callingLoader) || !ClassLoaders.containsClass((ClassLoader)this.callingLoader, exceptionType);
    }

    private boolean returnTypeNeedsEnhancement(Class<?> methodReturnType, Object returnValue, Class<?> unwrappedReturnValueType) {
        if (Proxies.isPassthroughType(unwrappedReturnValueType)) {
            return false;
        }
        if (!Object.class.equals(methodReturnType) && Proxies.isPassthroughType(methodReturnType)) {
            return false;
        }
        return unwrappedReturnValueType.getClassLoader() == null || unwrappedReturnValueType.getClassLoader().equals(this.callingLoader) || !ClassLoaders.containsClass((ClassLoader)this.callingLoader, unwrappedReturnValueType) || !ClassLoaders.containsClass((ClassLoader)this.callingLoader, methodReturnType);
    }

    private List<Object> enhanceParameterValues(Object[] args, Method delegateMethod) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (int i = 0; i < delegateMethod.getParameterTypes().length; ++i) {
            Class<?> delegateParameterType = delegateMethod.getParameterTypes()[i];
            Object parameterValue = args[i];
            parameterValues.add(this.enhanceSingleParameterValue(delegateMethod, delegateParameterType, parameterValue));
        }
        return parameterValues;
    }

    private Object enhanceSingleParameterValue(Method delegateMethod, Class<?> delegateParameterType, Object parameterValue) {
        if (parameterValue != null) {
            if (parameterValue instanceof Class) {
                Class<?> loadedClass;
                Class paramClassValue = (Class)parameterValue;
                try {
                    loadedClass = this.delegateLoader.loadClass(Proxies.unwrapProxyClassName(paramClassValue));
                }
                catch (ClassNotFoundException e) {
                    try {
                        loadedClass = this.unwrappedDelegateLoader.loadClass(Proxies.unwrapProxyClassName(paramClassValue));
                    }
                    catch (ClassNotFoundException cnfe) {
                        loadedClass = Proxies.unwrapProxyTypes(paramClassValue, new ClassLoader[0]);
                    }
                }
                return loadedClass;
            }
            Object unwrappedValue = Proxies.unwrapOnce(parameterValue);
            if (delegateParameterType.isAssignableFrom(unwrappedValue.getClass()) && !Proxies.isLanguageType(unwrappedValue.getClass()) && !ClassLoaderAdapterCallback.isEquals(delegateMethod)) {
                return unwrappedValue;
            }
            unwrappedValue = Proxies.unwrap(parameterValue);
            Class<?> unwrappedValueType = Proxies.unwrapProxyTypes(unwrappedValue.getClass(), delegateMethod.getDeclaringClass().getClassLoader(), this.callingLoader, this.delegateLoader, unwrappedValue.getClass().getClassLoader());
            ClassLoader valueDelegateLoader = this.delegateLoader;
            ClassLoader methodLoader = delegateMethod.getDeclaringClass().getClassLoader();
            if (methodLoader != null && ClassLoaders.containsClass((ClassLoader)methodLoader, unwrappedValueType)) {
                valueDelegateLoader = methodLoader;
            }
            ClassLoader valueCallingLoader = this.callingLoader;
            if (!ClassLoaders.containsClass((ClassLoader)this.callingLoader, unwrappedValueType)) {
                valueCallingLoader = unwrappedValueType.getClassLoader();
            }
            if (delegateParameterType.isPrimitive()) {
                return parameterValue;
            }
            if (delegateParameterType.isEnum()) {
                return this.enhanceEnum(methodLoader, parameterValue);
            }
            if (delegateParameterType.isArray()) {
                Object[] array = (Object[])unwrappedValue;
                Object[] delegateArray = (Object[])Array.newInstance(delegateParameterType.getComponentType(), array.length);
                for (int j = 0; j < array.length; ++j) {
                    delegateArray[j] = this.enhanceSingleParameterValue(delegateMethod, delegateParameterType.getComponentType(), array[j]);
                }
                return delegateArray;
            }
            Class<?> parameterType = parameterValue.getClass();
            if (!Proxies.isPassthroughType(delegateParameterType) && Proxies.isLanguageType(delegateParameterType) || !delegateParameterType.isAssignableFrom(parameterType) || ClassLoaderAdapterCallback.isEquals(delegateMethod)) {
                Class<?>[] compatibleClassHierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(valueDelegateLoader, unwrappedValueType);
                if (compatibleClassHierarchy.length == 0) {
                    compatibleClassHierarchy = new Class[]{delegateParameterType};
                }
                Object delegateParameterValue = ClassLoaderAdapterCallback.enhance(valueDelegateLoader, valueCallingLoader, parameterValue, compatibleClassHierarchy);
                return delegateParameterValue;
            }
            return unwrappedValue;
        }
        return null;
    }

    private static boolean isEquals(Method method) {
        return Boolean.TYPE.equals(method.getReturnType()) && "equals".equals(method.getName()) && method.getParameterTypes().length == 1 && Object.class.equals(method.getParameterTypes()[0]);
    }

    private List<Class<?>> translateParameterTypes(Method method) throws ClassNotFoundException {
        ArrayList parameterTypes = new ArrayList();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            if (parameterType.isPrimitive()) {
                parameterTypes.add(parameterType);
                continue;
            }
            Class<?> delegateParameterType = this.delegateLoader.loadClass(parameterType.getName());
            parameterTypes.add(delegateParameterType);
        }
        return parameterTypes;
    }

    public static <T> T enhance(ClassLoader callingLoader, ClassLoader delegateLoader, Object delegate, Class<?> ... types) {
        return ClassLoaderAdapterCallback.enhance(callingLoader, delegateLoader, null, delegate, types);
    }

    private static <T> T enhance(final ClassLoader callingLoader, final ClassLoader delegateLoader, Method sourceMethod, final Object delegate, final Class<?> ... types) {
        final Class<?> delegateType = delegate.getClass();
        try {
            return (T)ClassLoaders.executeIn((ClassLoader)JAVASSIST_LOADER, (Callable)new Callable<T>(){

                @Override
                public T call() throws Exception {
                    int index;
                    Class[] hierarchy = null;
                    if (types == null || types.length == 0) {
                        hierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(callingLoader, Proxies.unwrapProxyTypes(delegateType, callingLoader, delegateLoader));
                        if (hierarchy == null || hierarchy.length == 0) {
                            Logger.getLogger(this.getClass().getName()).fine("Must specify at least one non-final type to enhance for Object: " + delegate + " of type " + delegate.getClass());
                            return delegate;
                        }
                    } else {
                        hierarchy = Arrays.copy(types, new Class[types.length]);
                    }
                    MethodFilter filter = new MethodFilter(){

                        public boolean isHandled(Method method) {
                            return !method.getDeclaringClass().getName().contains("java.lang") || !Proxies.isPassthroughType(method.getDeclaringClass()) || "toString".equals(method.getName()) && method.getParameterTypes().length == 0 || ClassLoaderAdapterCallback.isEquals(method);
                        }
                    };
                    Object enhancedResult = null;
                    ProxyFactory f = new ProxyFactory(){

                        protected ClassLoader getClassLoader0() {
                            ClassLoader result = callingLoader;
                            if (!ClassLoaders.containsClass((ClassLoader)result, ProxyObject.class)) {
                                result = super.getClassLoader0();
                            }
                            return result;
                        }
                    };
                    f.setUseCache(true);
                    Class first = hierarchy[0];
                    if (!first.isInterface()) {
                        f.setSuperclass(Proxies.unwrapProxyTypes(first, callingLoader, delegateLoader));
                        hierarchy = Arrays.shiftLeft(hierarchy, new Class[hierarchy.length - 1]);
                    }
                    if ((index = Arrays.indexOf(hierarchy, ProxyObject.class)) >= 0) {
                        hierarchy = Arrays.removeElementAtIndex(hierarchy, index);
                    }
                    if (!Proxies.isProxyType(first) && !Arrays.contains(hierarchy, ForgeProxy.class)) {
                        hierarchy = Arrays.append(hierarchy, ForgeProxy.class);
                    }
                    if (hierarchy.length > 0) {
                        f.setInterfaces(hierarchy);
                    }
                    f.setFilter(filter);
                    Class c = f.createClass();
                    enhancedResult = c.newInstance();
                    try {
                        ((ProxyObject)enhancedResult).setHandler((MethodHandler)new ClassLoaderAdapterCallback(callingLoader, delegateLoader, delegate));
                    }
                    catch (ClassCastException e) {
                        Class<?>[] interfaces;
                        for (Class<?> javassistType : interfaces = enhancedResult.getClass().getInterfaces()) {
                            if (!ProxyObject.class.getName().equals(javassistType.getName()) && !Proxy.class.getName().equals(javassistType.getName())) continue;
                            String callbackClassName = ClassLoaderAdapterCallback.class.getName();
                            ClassLoader javassistLoader = javassistType.getClassLoader();
                            Constructor<?> callbackConstructor = javassistLoader.loadClass(callbackClassName).getConstructors()[0];
                            Class<?> typeArgument = javassistLoader.loadClass(MethodHandler.class.getName());
                            Method setHandlerMethod = javassistType.getMethod("setHandler", typeArgument);
                            setHandlerMethod.invoke(enhancedResult, callbackConstructor.newInstance(callingLoader, delegateLoader, delegate));
                        }
                    }
                    return enhancedResult;
                }
            });
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create proxy for type [" + delegateType + "]", (Throwable)e);
        }
    }

    @Override
    public Object getDelegate() throws Exception {
        return this.delegate;
    }
}

