/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.proxy.Arrays;
import org.jboss.forge.furnace.proxy.ClassLoaderInterceptor;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.proxy.Proxies;
import org.jboss.forge.furnace.proxy.ProxyTypeInspector;
import org.jboss.forge.furnace.proxy.javassist.util.proxy.MethodFilter;
import org.jboss.forge.furnace.proxy.javassist.util.proxy.MethodHandler;
import org.jboss.forge.furnace.proxy.javassist.util.proxy.Proxy;
import org.jboss.forge.furnace.proxy.javassist.util.proxy.ProxyFactory;
import org.jboss.forge.furnace.proxy.javassist.util.proxy.ProxyObject;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ClassLoaderAdapterCallback
implements MethodHandler,
ForgeProxy {
    private static final Logger log = Logger.getLogger(ClassLoaderAdapterCallback.class.getName());
    private static final ClassLoader JAVASSIST_LOADER = ProxyObject.class.getClassLoader();
    private final Object delegate;
    private final ClassLoader initialCallingLoader;
    private final ClassLoader delegateLoader;
    private final Callable<Set<ClassLoader>> whitelist;

    private ClassLoader getCallingLoader() {
        ClassLoader callingLoader = ClassLoaderInterceptor.getCurrentloader();
        if (callingLoader == null) {
            callingLoader = this.initialCallingLoader;
        }
        return callingLoader;
    }

    public ClassLoaderAdapterCallback(Callable<Set<ClassLoader>> whitelist, ClassLoader callingLoader, ClassLoader delegateLoader, Object delegate) {
        Assert.notNull(whitelist, (String)"ClassLoader whitelist must not be null");
        Assert.notNull((Object)callingLoader, (String)"Calling loader must not be null.");
        Assert.notNull((Object)delegateLoader, (String)"Delegate loader must not be null.");
        Assert.notNull((Object)delegate, (String)"Delegate must not be null.");
        this.whitelist = whitelist;
        this.initialCallingLoader = callingLoader;
        this.delegateLoader = delegateLoader;
        this.delegate = delegate;
    }

    public Object invoke(Object obj, final Method thisMethod, Method proceed, final Object[] args) throws Throwable {
        if (Thread.currentThread().isInterrupted()) {
            throw new ContainerException("Thread.interrupt() requested.");
        }
        return ClassLoaders.executeIn((ClassLoader)this.delegateLoader, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (thisMethod.getDeclaringClass().equals(ClassLoaderAdapterCallback.this.getCallingLoader().loadClass(ForgeProxy.class.getName()))) {
                        if (thisMethod.getName().equals("getDelegate")) {
                            return ClassLoaderAdapterCallback.this.getDelegate();
                        }
                        if (thisMethod.getName().equals("getHandler")) {
                            return ClassLoaderAdapterCallback.this.getHandler();
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                Method delegateMethod = this.getDelegateMethod(thisMethod);
                List parameterValues = ClassLoaderAdapterCallback.this.enhanceParameterValues(args, delegateMethod);
                AccessibleObject.setAccessible(new AccessibleObject[]{delegateMethod}, true);
                try {
                    Object[] parameterValueArray = parameterValues.toArray();
                    Object result = delegateMethod.invoke(ClassLoaderAdapterCallback.this.delegate, parameterValueArray);
                    return ClassLoaderAdapterCallback.this.enhanceResult(thisMethod, result);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof Exception) {
                        throw ClassLoaderAdapterCallback.this.enhanceException(delegateMethod, (Exception)e.getCause());
                    }
                    throw ClassLoaderAdapterCallback.this.enhanceException(delegateMethod, e);
                }
            }

            private Method getDelegateMethod(Method proxy) throws ClassNotFoundException, NoSuchMethodException {
                Method delegateMethod;
                block4: {
                    delegateMethod = null;
                    try {
                        List parameterTypes = ClassLoaderAdapterCallback.this.translateParameterTypes(proxy);
                        delegateMethod = ClassLoaderAdapterCallback.this.delegate.getClass().getMethod(proxy.getName(), parameterTypes.toArray(new Class[parameterTypes.size()]));
                    }
                    catch (ClassNotFoundException e) {
                        block2: for (Method m : ClassLoaderAdapterCallback.this.delegate.getClass().getMethods()) {
                            Class<?>[] delegateParameterTypes;
                            Class<?>[] methodParameterTypes;
                            String delegateMethodName;
                            String methodName = proxy.getName();
                            if (!methodName.equals(delegateMethodName = m.getName()) || (methodParameterTypes = proxy.getParameterTypes()).length != (delegateParameterTypes = m.getParameterTypes()).length) continue;
                            for (int i = 0; i < methodParameterTypes.length; ++i) {
                                Class<?> methodType = methodParameterTypes[i];
                                Class<?> delegateType = delegateParameterTypes[i];
                                if (!methodType.getName().equals(delegateType.getName())) continue block2;
                            }
                            delegateMethod = m;
                            break;
                        }
                        if (delegateMethod != null) break block4;
                        throw e;
                    }
                }
                return delegateMethod;
            }
        });
    }

    private Object enhanceResult(Method method, Object result) throws Exception {
        if (result != null) {
            Class<?> returnType;
            Class<?> unwrappedResultType = Proxies.unwrap(result).getClass();
            ClassLoader callingLoader = this.getCallingLoader();
            if (this.getCallingLoader().equals(this.delegateLoader)) {
                callingLoader = this.getInitialCallingLoader();
            }
            ClassLoader resultInstanceLoader = this.delegateLoader;
            if (!ClassLoaders.containsClass((ClassLoader)this.delegateLoader, unwrappedResultType) && (resultInstanceLoader = Proxies.unwrapProxyTypes(unwrappedResultType, this.getCallingLoader(), this.delegateLoader, unwrappedResultType.getClassLoader()).getClassLoader()) == null) {
                resultInstanceLoader = this.getClass().getClassLoader();
            }
            if (Class.class.equals(returnType = method.getReturnType())) {
                block15: {
                    Class resultClassValue = (Class)result;
                    try {
                        result = callingLoader.loadClass(Proxies.unwrapProxyClassName(resultClassValue));
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            result = this.loadClassFromWhitelist(Proxies.unwrapProxyClassName(resultClassValue));
                        }
                        catch (ClassNotFoundException e3) {
                            // empty catch block
                        }
                        if (result != null) break block15;
                        result = Proxies.unwrapProxyTypes(resultClassValue, new ClassLoader[0]);
                    }
                }
                return result;
            }
            if (this.returnTypeNeedsEnhancement(returnType, result, unwrappedResultType)) {
                result = this.stripClassLoaderAdapters(result);
                Class<?>[] resultHierarchy = this.removeProxyTypes(ProxyTypeInspector.getCompatibleClassHierarchy(callingLoader, result.getClass()));
                Class<?>[] unwrappedResultHierarchy = this.removeProxyTypes(ProxyTypeInspector.getCompatibleClassHierarchy(callingLoader, unwrappedResultType));
                resultHierarchy = this.mergeHierarchies(resultHierarchy, unwrappedResultHierarchy);
                Class<?>[] returnTypeHierarchy = this.removeProxyTypes(ProxyTypeInspector.getCompatibleClassHierarchy(callingLoader, returnType));
                if (!Modifier.isFinal(returnType.getModifiers())) {
                    if (Object.class.equals(returnType) && !Object.class.equals(result)) {
                        result = ClassLoaderAdapterCallback.enhance(this.whitelist, callingLoader, resultInstanceLoader, method, result, resultHierarchy);
                    } else {
                        ClassLoaderAdapterCallback handler;
                        if (returnTypeHierarchy.length == 0) {
                            returnTypeHierarchy = new Class[]{returnType};
                        }
                        Object delegateObject = result;
                        if (result instanceof ForgeProxy && ((ForgeProxy)result).getHandler() instanceof ClassLoaderAdapterCallback && (handler = (ClassLoaderAdapterCallback)((ForgeProxy)result).getHandler()).getCallingLoader().equals(this.getCallingLoader()) && handler.getDelegateLoader().equals(this.getDelegateLoader())) {
                            delegateObject = this.stripClassLoaderAdapters(result);
                        }
                        result = ClassLoaderAdapterCallback.enhance(this.whitelist, callingLoader, resultInstanceLoader, method, delegateObject, this.mergeHierarchies(returnTypeHierarchy, resultHierarchy));
                    }
                } else {
                    result = result.getClass().isEnum() ? this.enhanceEnum(callingLoader, result) : ClassLoaderAdapterCallback.enhance(this.whitelist, callingLoader, resultInstanceLoader, (Object)method, returnTypeHierarchy);
                }
            }
        }
        return result;
    }

    private Class<?>[] removeProxyTypes(Class<?>[] types) {
        ArrayList result = new ArrayList();
        if (types != null) {
            for (Class<?> type : types) {
                if (Proxies.isProxyType(type)) continue;
                result.add(type);
            }
        }
        return result.toArray(new Class[result.size()]);
    }

    private Object stripClassLoaderAdapters(Object value) {
        Object handler;
        while (Proxies.isForgeProxy(value) && (handler = Proxies.getForgeProxyHandler(value)).getClass().getName().equals(ClassLoaderAdapterCallback.class.getName())) {
            value = Proxies.unwrapOnce(value);
        }
        return value;
    }

    private Exception enhanceException(Method method, Exception exception) {
        Exception result = exception;
        try {
            if (exception != null) {
                Class<?> unwrappedExceptionType = Proxies.unwrap(exception).getClass();
                ClassLoader exceptionLoader = this.delegateLoader;
                if (!ClassLoaders.containsClass((ClassLoader)this.delegateLoader, unwrappedExceptionType) && (exceptionLoader = Proxies.unwrapProxyTypes(unwrappedExceptionType, this.getCallingLoader(), this.delegateLoader, unwrappedExceptionType.getClassLoader()).getClassLoader()) == null) {
                    exceptionLoader = this.getClass().getClassLoader();
                }
                if (this.exceptionNeedsEnhancement(exception)) {
                    Class<?>[] exceptionHierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(this.getCallingLoader(), Proxies.unwrapProxyTypes(exception.getClass(), this.getCallingLoader(), this.delegateLoader, exceptionLoader));
                    if (!Modifier.isFinal(unwrappedExceptionType.getModifiers())) {
                        result = (Exception)ClassLoaderAdapterCallback.enhance(this.whitelist, this.getCallingLoader(), exceptionLoader, method, exception, exceptionHierarchy);
                        result.initCause(exception);
                        result.setStackTrace(exception.getStackTrace());
                    }
                }
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Could not enhance exception for passing through ClassLoader boundary. Exception type [" + exception.getClass().getName() + "], Caller [" + this.getCallingLoader() + "], Delegate [" + this.delegateLoader + "]");
            return exception;
        }
        return result;
    }

    private Object enhanceEnum(ClassLoader loader, Object instance) {
        try {
            Class<?> callingType = loader.loadClass(instance.getClass().getName());
            return Enum.valueOf(callingType, ((Enum)instance).name());
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException("Could not enhance instance [" + instance + "] of type [" + instance.getClass() + "]", (Throwable)e);
        }
    }

    private Class<?>[] mergeHierarchies(Class<?>[] left, Class<?>[] right) {
        for (Class<?> type : right) {
            boolean found = false;
            for (Class<?> existing : left) {
                if (!type.equals(existing)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (type.isInterface()) {
                left = Arrays.append(left, type);
                continue;
            }
            if (left.length != 0 && !left[0].isInterface()) continue;
            left = Arrays.prepend(left, type);
        }
        return left;
    }

    private boolean exceptionNeedsEnhancement(Exception exception) {
        Class<?> exceptionType = exception.getClass();
        Class<?> unwrappedExceptionType = Proxies.unwrap(exception).getClass();
        if (Proxies.isPassthroughType(unwrappedExceptionType)) {
            return false;
        }
        return unwrappedExceptionType.getClassLoader() == null || exceptionType.getClassLoader().equals(this.getCallingLoader()) || !ClassLoaders.containsClass((ClassLoader)this.getCallingLoader(), exceptionType);
    }

    private boolean returnTypeNeedsEnhancement(Class<?> methodReturnType, Object returnValue, Class<?> unwrappedReturnValueType) {
        if (Proxies.isPassthroughType(unwrappedReturnValueType)) {
            return false;
        }
        if (!Object.class.equals(methodReturnType) && Proxies.isPassthroughType(methodReturnType)) {
            return false;
        }
        return unwrappedReturnValueType.getClassLoader() == null || unwrappedReturnValueType.getClassLoader().equals(this.getCallingLoader()) || !ClassLoaders.containsClass((ClassLoader)this.getCallingLoader(), unwrappedReturnValueType) || !ClassLoaders.containsClass((ClassLoader)this.getCallingLoader(), methodReturnType);
    }

    private static boolean whitelistContainsAll(Callable<Set<ClassLoader>> whitelist, ClassLoader ... classLoaders) {
        try {
            Set<ClassLoader> set = whitelist.call();
            for (ClassLoader classLoader : classLoaders) {
                if (set.contains(classLoader)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve ClassLoader whitelist from callback [" + whitelist + "].", e);
        }
    }

    private Class<?> loadClassFromWhitelist(String typeName) throws ClassNotFoundException {
        Set<ClassLoader> loaders;
        try {
            loaders = this.whitelist.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve ClassLoader whitelist from callback [" + this.whitelist + "].", e);
        }
        for (ClassLoader loader : loaders) {
            try {
                Class<?> result = loader.loadClass(typeName);
                return result;
            }
            catch (Exception e) {
            }
        }
        throw new ClassNotFoundException(typeName);
    }

    private List<Object> enhanceParameterValues(Object[] args, Method delegateMethod) throws Exception {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        for (int i = 0; i < delegateMethod.getParameterTypes().length; ++i) {
            Class<?> delegateParameterType = delegateMethod.getParameterTypes()[i];
            Object parameterValue = args[i];
            parameterValues.add(this.enhanceSingleParameterValue(delegateMethod, delegateParameterType, this.stripClassLoaderAdapters(parameterValue)));
        }
        return parameterValues;
    }

    private Object enhanceSingleParameterValue(Method delegateMethod, Class<?> delegateParameterType, Object parameterValue) throws Exception {
        if (parameterValue != null) {
            if (parameterValue instanceof Class) {
                Class<?> loadedClass;
                block16: {
                    Class paramClassValue = (Class)parameterValue;
                    loadedClass = null;
                    try {
                        loadedClass = this.delegateLoader.loadClass(Proxies.unwrapProxyClassName(paramClassValue));
                    }
                    catch (ClassNotFoundException e) {
                        try {
                            loadedClass = this.loadClassFromWhitelist(Proxies.unwrapProxyClassName(paramClassValue));
                        }
                        catch (ClassNotFoundException e3) {
                            // empty catch block
                        }
                        if (loadedClass != null) break block16;
                        loadedClass = Proxies.unwrapProxyTypes(paramClassValue, new ClassLoader[0]);
                    }
                }
                return loadedClass;
            }
            Object unwrappedValue = this.stripClassLoaderAdapters(parameterValue);
            if (delegateParameterType.isAssignableFrom(unwrappedValue.getClass()) && !Proxies.isLanguageType(unwrappedValue.getClass()) && (!ClassLoaderAdapterCallback.isEquals(delegateMethod) || ClassLoaderAdapterCallback.isEquals(delegateMethod) && ClassLoaders.containsClass((ClassLoader)this.delegateLoader, unwrappedValue.getClass()))) {
                return unwrappedValue;
            }
            Class<?> unwrappedValueType = Proxies.unwrapProxyTypes(unwrappedValue.getClass(), delegateMethod.getDeclaringClass().getClassLoader(), this.getCallingLoader(), this.delegateLoader, unwrappedValue.getClass().getClassLoader());
            ClassLoader valueDelegateLoader = this.delegateLoader;
            ClassLoader methodLoader = delegateMethod.getDeclaringClass().getClassLoader();
            if (methodLoader != null && ClassLoaders.containsClass((ClassLoader)methodLoader, unwrappedValueType)) {
                valueDelegateLoader = methodLoader;
            }
            ClassLoader valueCallingLoader = this.getCallingLoader();
            ClassLoader unwrappedValueLoader = unwrappedValueType.getClassLoader();
            if (unwrappedValueLoader != null && !ClassLoaders.containsClass((ClassLoader)this.getCallingLoader(), unwrappedValueType)) {
                valueCallingLoader = unwrappedValueLoader;
            }
            if (delegateParameterType.isPrimitive()) {
                return parameterValue;
            }
            if (delegateParameterType.isEnum()) {
                return this.enhanceEnum(methodLoader, parameterValue);
            }
            if (delegateParameterType.isArray()) {
                Object[] array = (Object[])unwrappedValue;
                Object[] delegateArray = (Object[])Array.newInstance(delegateParameterType.getComponentType(), array.length);
                for (int j = 0; j < array.length; ++j) {
                    delegateArray[j] = this.enhanceSingleParameterValue(delegateMethod, delegateParameterType.getComponentType(), this.stripClassLoaderAdapters(array[j]));
                }
                return delegateArray;
            }
            Class<?> parameterType = parameterValue.getClass();
            if (!Proxies.isPassthroughType(delegateParameterType) && Proxies.isLanguageType(delegateParameterType) || !delegateParameterType.isAssignableFrom(parameterType) || ClassLoaderAdapterCallback.isEquals(delegateMethod)) {
                ClassLoaderAdapterCallback handler;
                Class<?>[] compatibleClassHierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(valueDelegateLoader, unwrappedValueType);
                if (compatibleClassHierarchy.length == 0) {
                    compatibleClassHierarchy = new Class[]{delegateParameterType};
                }
                Object delegateObject = parameterValue;
                if (parameterValue instanceof ForgeProxy && ((ForgeProxy)parameterValue).getHandler() instanceof ClassLoaderAdapterCallback && (handler = (ClassLoaderAdapterCallback)((ForgeProxy)parameterValue).getHandler()).getCallingLoader().equals(this.getCallingLoader()) && handler.getDelegateLoader().equals(this.getDelegateLoader()) && delegateParameterType.isAssignableFrom(unwrappedValue.getClass())) {
                    delegateObject = unwrappedValue;
                }
                Object delegateParameterValue = ClassLoaderAdapterCallback.enhance(this.whitelist, valueDelegateLoader, valueCallingLoader, delegateObject, compatibleClassHierarchy);
                return delegateParameterValue;
            }
            return unwrappedValue;
        }
        return null;
    }

    private static boolean isEquals(Method method) {
        return Boolean.TYPE.equals(method.getReturnType()) && "equals".equals(method.getName()) && method.getParameterTypes().length == 1 && Object.class.equals(method.getParameterTypes()[0]);
    }

    private static boolean isHashCode(Method method) {
        return Integer.TYPE.equals(method.getReturnType()) && "hashCode".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    private static boolean isAutoCloseableClose(Method method) {
        return Void.TYPE.equals(method.getReturnType()) && "close".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    private List<Class<?>> translateParameterTypes(Method method) throws ClassNotFoundException {
        ArrayList parameterTypes = new ArrayList();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> parameterType = method.getParameterTypes()[i];
            if (parameterType.isPrimitive()) {
                parameterTypes.add(parameterType);
                continue;
            }
            Class<?> delegateParameterType = this.delegateLoader.loadClass(parameterType.getName());
            parameterTypes.add(delegateParameterType);
        }
        return parameterTypes;
    }

    static <T> T enhance(Callable<Set<ClassLoader>> whitelist, ClassLoader callingLoader, ClassLoader delegateLoader, Object delegate, Class<?> ... types) {
        return ClassLoaderAdapterCallback.enhance(whitelist, callingLoader, delegateLoader, null, delegate, types);
    }

    private static <T> T enhance(final Callable<Set<ClassLoader>> whitelist, final ClassLoader callingLoader, final ClassLoader delegateLoader, Method sourceMethod, final Object delegate, final Class<?> ... types) {
        if (ClassLoaderAdapterCallback.whitelistContainsAll(whitelist, callingLoader, delegateLoader)) {
            return (T)delegate;
        }
        final Class<?> delegateType = delegate.getClass();
        try {
            return (T)ClassLoaders.executeIn((ClassLoader)JAVASSIST_LOADER, (Callable)new Callable<T>(){

                @Override
                public T call() throws Exception {
                    int index;
                    Class[] hierarchy = null;
                    if (types == null || types.length == 0) {
                        hierarchy = ProxyTypeInspector.getCompatibleClassHierarchy(callingLoader, Proxies.unwrapProxyTypes(delegateType, callingLoader, delegateLoader));
                        if (hierarchy == null || hierarchy.length == 0) {
                            Logger.getLogger(this.getClass().getName()).fine("Must specify at least one non-final type to enhance for Object: " + delegate + " of type " + delegate.getClass());
                            return delegate;
                        }
                    } else {
                        hierarchy = Arrays.copy(types, new Class[types.length]);
                    }
                    MethodFilter filter = new MethodFilter(){

                        public boolean isHandled(Method method) {
                            return !method.getDeclaringClass().getName().contains("java.lang") || !Proxies.isPassthroughType(method.getDeclaringClass()) || "toString".equals(method.getName()) && method.getParameterTypes().length == 0 || ClassLoaderAdapterCallback.isEquals(method) || ClassLoaderAdapterCallback.isHashCode(method) || ClassLoaderAdapterCallback.isAutoCloseableClose(method) || Arrays.contains(types, method.getDeclaringClass());
                        }
                    };
                    Object enhancedResult = null;
                    ProxyFactory f = new ProxyFactory(){

                        protected ClassLoader getClassLoader0() {
                            ClassLoader result = callingLoader;
                            if (!ClassLoaders.containsClass((ClassLoader)result, ProxyObject.class)) {
                                result = super.getClassLoader0();
                            }
                            return result;
                        }
                    };
                    f.setUseCache(true);
                    Class first = hierarchy[0];
                    if (!first.isInterface()) {
                        f.setSuperclass(Proxies.unwrapProxyTypes(first, callingLoader, delegateLoader));
                        hierarchy = Arrays.shiftLeft(hierarchy, new Class[hierarchy.length - 1]);
                    }
                    if ((index = Arrays.indexOf(hierarchy, ProxyObject.class)) >= 0) {
                        hierarchy = Arrays.removeElementAtIndex(hierarchy, index);
                    }
                    if (!Proxies.isProxyType(first) && !Arrays.contains(hierarchy, ForgeProxy.class)) {
                        hierarchy = Arrays.append(hierarchy, ForgeProxy.class);
                    }
                    if (hierarchy.length > 0) {
                        f.setInterfaces(hierarchy);
                    }
                    f.setFilter(filter);
                    Class c = f.createClass();
                    enhancedResult = c.newInstance();
                    try {
                        ((ProxyObject)enhancedResult).setHandler((MethodHandler)new ClassLoaderAdapterCallback(whitelist, callingLoader, delegateLoader, delegate));
                    }
                    catch (ClassCastException e) {
                        Class<?>[] interfaces;
                        for (Class<?> javassistType : interfaces = enhancedResult.getClass().getInterfaces()) {
                            if (!ProxyObject.class.getName().equals(javassistType.getName()) && !Proxy.class.getName().equals(javassistType.getName())) continue;
                            String callbackClassName = ClassLoaderAdapterCallback.class.getName();
                            ClassLoader javassistLoader = javassistType.getClassLoader();
                            Constructor<?> callbackConstructor = javassistLoader.loadClass(callbackClassName).getConstructors()[0];
                            Class<?> typeArgument = javassistLoader.loadClass(MethodHandler.class.getName());
                            Method setHandlerMethod = javassistType.getMethod("setHandler", typeArgument);
                            setHandlerMethod.invoke(enhancedResult, callbackConstructor.newInstance(whitelist, callingLoader, delegateLoader, delegate));
                        }
                    }
                    return enhancedResult;
                }
            });
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create proxy for type [" + delegateType + "]", (Throwable)e);
        }
    }

    @Override
    public Object getDelegate() throws Exception {
        return this.delegate;
    }

    @Override
    public Object getHandler() throws Exception {
        return this;
    }

    public ClassLoader getDelegateLoader() {
        return this.delegateLoader;
    }

    public ClassLoader getInitialCallingLoader() {
        return this.initialCallingLoader;
    }
}

