/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.proxy.ForgeProxy;
import org.jboss.forge.furnace.util.ClassLoaders;

public class ClassLoaderInterceptor
implements ForgeProxy {
    private static final ThreadLocal<ClassLoader> currentLoader = new ThreadLocal();
    private final ClassLoader loader;
    private final Object delegate;

    public ClassLoaderInterceptor(ClassLoader loader, Object delegate) {
        this.loader = loader;
        this.delegate = delegate;
    }

    public Object invoke(Object self, final Method thisMethod, Method proceed, final Object[] args) throws Throwable {
        if (Thread.currentThread().isInterrupted()) {
            throw new ContainerException("Thread.interrupt() requested.");
        }
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                Object result;
                try {
                    if (thisMethod.getDeclaringClass().getName().equals(ForgeProxy.class.getName())) {
                        if (thisMethod.getName().equals("getDelegate")) {
                            return ClassLoaderInterceptor.this.getDelegate();
                        }
                        if (thisMethod.getName().equals("getHandler")) {
                            return ClassLoaderInterceptor.this.getHandler();
                        }
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ClassLoader previousLoader = null;
                try {
                    previousLoader = ClassLoaderInterceptor.setCurrentLoader(ClassLoaderInterceptor.this.loader);
                    result = thisMethod.invoke(ClassLoaderInterceptor.this.delegate, args);
                }
                catch (InvocationTargetException e) {
                    try {
                        if (e.getCause() instanceof Exception) {
                            throw (Exception)e.getCause();
                        }
                        throw e;
                    }
                    catch (Throwable throwable) {
                        ClassLoaderInterceptor.setCurrentLoader(previousLoader);
                        throw throwable;
                    }
                }
                ClassLoaderInterceptor.setCurrentLoader(previousLoader);
                return result;
            }
        };
        return ClassLoaders.executeIn((ClassLoader)this.loader, (Callable)task);
    }

    public static ClassLoader getCurrentloader() {
        return currentLoader.get();
    }

    private static ClassLoader setCurrentLoader(ClassLoader loader) {
        ClassLoader previous = currentLoader.get();
        currentLoader.set(loader);
        return previous;
    }

    @Override
    public Object getDelegate() throws Exception {
        return this.delegate;
    }

    @Override
    public Object getHandler() throws Exception {
        return this;
    }
}

