/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.JavaType;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.impl.TypeImpl;
import org.jboss.forge.parser.java.source.JavaClassSource;
import org.jboss.forge.parser.java.source.JavaSource;
import org.jboss.forge.parser.java.source.TypeVariableSource;
import org.jboss.forge.parser.java.util.Assert;

public class TypeVariableImpl<O extends JavaSource<O>>
implements TypeVariableSource<O> {
    private final O origin;
    private final TypeParameter internal;

    public TypeVariableImpl(O origin, TypeParameter internal) {
        Assert.notNull(origin, (String)"null origin");
        this.origin = origin;
        Assert.notNull((Object)internal, (String)"null internal representation");
        this.internal = internal;
    }

    public List<Type<O>> getBounds() {
        List typeBounds = this.internal.typeBounds();
        if (typeBounds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<TypeImpl<O>> result = new ArrayList<TypeImpl<O>>(typeBounds.size());
        for (org.eclipse.jdt.core.dom.Type type : typeBounds) {
            result.add(new TypeImpl<O>(this.origin, type));
        }
        return Collections.unmodifiableList(result);
    }

    public String getName() {
        return this.internal.getName().getIdentifier();
    }

    public Object getInternal() {
        return this.internal;
    }

    public O getOrigin() {
        return this.origin;
    }

    public TypeVariableSource<O> setName(String name) {
        this.internal.setName(this.internal.getAST().newSimpleName(name));
        return this;
    }

    public TypeVariableSource<O> setBounds(JavaType<?> ... bounds) {
        String[] names;
        if (bounds == null) {
            names = new String[]{};
        } else {
            names = new String[bounds.length];
            int i = 0;
            for (JavaType<?> t : bounds) {
                names[i++] = this.origin.addImport(t).getSimpleName();
            }
        }
        return this.setBounds(names);
    }

    public TypeVariableSource<O> setBounds(Class<?> ... bounds) {
        String[] names;
        if (bounds == null) {
            names = new String[]{};
        } else {
            names = new String[bounds.length];
            int i = 0;
            for (Class<?> cls : bounds) {
                names[i++] = this.origin.addImport(cls).getSimpleName();
            }
        }
        return this.setBounds(names);
    }

    public TypeVariableSource<O> setBounds(String ... bounds) {
        this.internal.typeBounds().clear();
        for (String s : bounds) {
            org.eclipse.jdt.core.dom.Type copy = (org.eclipse.jdt.core.dom.Type)ASTNode.copySubtree((AST)this.internal.getAST(), (ASTNode)this.parseTypeBound(s));
            this.internal.typeBounds().add(copy);
        }
        return this;
    }

    public TypeVariableSource<O> removeBounds() {
        this.internal.typeBounds().clear();
        return this;
    }

    private org.eclipse.jdt.core.dom.Type parseTypeBound(String bound) {
        String stub = "public class Stub<T extends " + bound + "> {}";
        JavaClassSource temp = (JavaClassSource)JavaParser.parse(JavaClassSource.class, (String)stub);
        TypeParameter v = (TypeParameter)((TypeVariableSource)temp.getTypeVariables().get(0)).getInternal();
        return (org.eclipse.jdt.core.dom.Type)v.typeBounds().get(0);
    }
}

