/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.javaee.cdi;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.builder.DependencyBuilder;
import org.jboss.forge.javaee.AbstractJavaEEFacet;
import org.jboss.forge.javaee.spec.CDIFacet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.dependencies.DependencyInstaller;
import org.jboss.forge.projects.facets.PackagingFacet;
import org.jboss.forge.projects.facets.ResourceFacet;
import org.jboss.forge.projects.facets.WebResourceFacet;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.FileResource;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;

public class CDIFacetImpl
extends AbstractJavaEEFacet
implements CDIFacet {
    private static final Dependency JBOSS_ANNOTATION_API = DependencyBuilder.create((String)"org.jboss.spec.javax.annotation:jboss-annotations-api_1.1_spec");
    private static final Dependency JAVAX_INTERCEPTOR_API = DependencyBuilder.create((String)"org.jboss.spec.javax.interceptor:jboss-interceptors-api_1.1_spec");
    private static final Dependency JAVAX_INJECT = DependencyBuilder.create((String)"javax.inject:javax.inject");
    private static final Dependency JAVAX_ANNOTATION_API = DependencyBuilder.create((String)"javax.annotation:jsr250-api");
    private static final Dependency CDI_API = DependencyBuilder.create((String)"javax.enterprise:cdi-api");

    @Inject
    public CDIFacetImpl(DependencyInstaller installer) {
        super(installer);
    }

    @Override
    public boolean isInstalled() {
        return this.getConfigFile().exists() && super.isInstalled();
    }

    public BeansDescriptor getConfig() {
        DescriptorImporter importer = Descriptors.importAs(BeansDescriptor.class);
        BeansDescriptor descriptor = (BeansDescriptor)importer.fromStream(this.getConfigFile().getResourceInputStream());
        return descriptor;
    }

    @Override
    public boolean install() {
        FileResource<?> descriptor;
        if (!this.isInstalled() && !(descriptor = this.getConfigFile()).exists()) {
            if (!descriptor.createNewFile()) {
                throw new RuntimeException("Failed to create required [" + descriptor.getFullyQualifiedName() + "]");
            }
            String data = ((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString();
            descriptor.setContents(data);
        }
        return super.install();
    }

    public void saveConfig(BeansDescriptor model) {
        String output = model.exportAsString();
        this.getConfigFile().setContents(output);
    }

    public FileResource<?> getConfigFile() {
        Project project = (Project)this.getOrigin();
        PackagingFacet packaging = (PackagingFacet)project.getFacet(PackagingFacet.class);
        if ("war".equals(packaging.getPackagingType())) {
            DirectoryResource webRoot = ((WebResourceFacet)project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
            return (FileResource)webRoot.getChild("WEB-INF" + File.separator + "beans.xml");
        }
        DirectoryResource root = ((ResourceFacet)project.getFacet(ResourceFacet.class)).getResourceFolder();
        return (FileResource)root.getChild("META-INF" + File.separator + "beans.xml");
    }

    @Override
    protected Map<Dependency, List<Dependency>> getRequiredDependencyOptions() {
        LinkedHashMap<Dependency, List<Dependency>> result = new LinkedHashMap<Dependency, List<Dependency>>();
        result.put(CDI_API, Arrays.asList(CDI_API));
        result.put(JAVAX_ANNOTATION_API, Arrays.asList(JAVAX_ANNOTATION_API, JBOSS_ANNOTATION_API));
        result.put(JAVAX_INJECT, Arrays.asList(JAVAX_INJECT));
        result.put(JAVAX_INTERCEPTOR_API, Arrays.asList(JAVAX_INTERCEPTOR_API));
        return result;
    }
}

