/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.util.graph.selector.StaticDependencySelector;

public class AddonDependencySelector
implements DependencySelector {
    private static final String FORGE_ADDON = "forge-addon";
    private final int depth;

    public AddonDependencySelector() {
        this.depth = 0;
    }

    public AddonDependencySelector(int depth) {
        this.depth = depth;
    }

    public boolean selectDependency(Dependency dependency) {
        if (this.depth < 1) {
            return true;
        }
        String scope = dependency.getScope();
        String classifier = dependency.getArtifact().getClassifier();
        if ("test".equals(scope)) {
            return false;
        }
        boolean result = FORGE_ADDON.equals(classifier) && this.depth == 1 || !FORGE_ADDON.equals(classifier) && !"provided".equals(scope);
        return result;
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.depth > 0 && FORGE_ADDON.equals(context.getDependency().getArtifact().getClassifier())) {
            return new StaticDependencySelector(false);
        }
        return new AddonDependencySelector(this.depth + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AddonDependencySelector that = (AddonDependencySelector)obj;
        return this.depth == that.depth;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.depth;
        return hash;
    }
}

