/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.settings.Settings;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.DependencyNode;
import org.jboss.forge.dependencies.DependencyRepository;
import org.jboss.forge.dependencies.builder.DependencyBuilder;
import org.jboss.forge.dependencies.builder.DependencyNodeBuilder;
import org.jboss.forge.resource.FileResource;
import org.jboss.forge.resource.ResourceFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;

class MavenConvertUtils {
    MavenConvertUtils() {
    }

    static RemoteRepository convertToMavenRepo(DependencyRepository repo, Settings settings) {
        RemoteRepository remoteRepository = new RemoteRepository(repo.getId(), "default", repo.getUrl());
        org.apache.maven.settings.Proxy activeProxy = settings.getActiveProxy();
        if (activeProxy != null) {
            Authentication auth = new Authentication(activeProxy.getUsername(), activeProxy.getPassword());
            remoteRepository.setProxy(new Proxy(activeProxy.getProtocol(), activeProxy.getHost(), activeProxy.getPort(), auth));
        }
        return remoteRepository;
    }

    static List<RemoteRepository> convertToMavenRepos(List<DependencyRepository> repositories, Settings settings) {
        ArrayList<RemoteRepository> remoteRepos = new ArrayList<RemoteRepository>();
        for (DependencyRepository deprep : repositories) {
            remoteRepos.add(MavenConvertUtils.convertToMavenRepo(deprep, settings));
        }
        return remoteRepos;
    }

    static Artifact coordinateToMavenArtifact(Coordinate dep) {
        DefaultArtifact artifact = new DefaultArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getPackaging() == null ? "jar" : dep.getPackaging(), dep.getVersion());
        return artifact;
    }

    static org.jboss.forge.dependencies.Dependency convertToDependency(ResourceFactory factory, org.sonatype.aether.graph.DependencyNode node) {
        Dependency artifactDependency = node.getDependency();
        Artifact artifact = artifactDependency.getArtifact();
        File file = artifact.getFile();
        FileResource artifactResource = (FileResource)factory.create(FileResource.class, (Object)file);
        DependencyBuilder d = DependencyBuilder.create().setArtifactId(artifact.getArtifactId()).setGroupId(artifact.getGroupId()).setVersion(artifact.getBaseVersion()).setPackaging(artifact.getExtension()).setArtifact(artifactResource).setOptional(artifactDependency.isOptional()).setClassifier(artifact.getClassifier()).setScopeType(artifactDependency.getScope());
        return d;
    }

    static DependencyNodeBuilder toDependencyNode(ResourceFactory factory, DependencyNode parent, org.sonatype.aether.graph.DependencyNode aetherNode) {
        DependencyNodeBuilder node = DependencyNodeBuilder.create((DependencyNode)parent, (org.jboss.forge.dependencies.Dependency)MavenConvertUtils.convertToDependency(factory, aetherNode));
        for (org.sonatype.aether.graph.DependencyNode childNode : aetherNode.getChildren()) {
            node.getChildren().add(MavenConvertUtils.toDependencyNode(factory, (DependencyNode)node, childNode));
        }
        return node;
    }
}

