/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.providers.file.FileWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpWagon;
import org.apache.maven.wagon.providers.http.LightweightHttpWagonAuthenticator;
import org.apache.maven.wagon.providers.http.LightweightHttpsWagon;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.sonatype.aether.connector.wagon.WagonProvider;

class ManualWagonProvider
implements WagonProvider {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String FILE = "file";

    ManualWagonProvider() {
    }

    public Wagon lookup(String roleHint) throws Exception {
        if (roleHint.equals(HTTP)) {
            return this.setAuthenticator(new LightweightHttpWagon());
        }
        if (roleHint.equals(HTTPS)) {
            return this.setAuthenticator((LightweightHttpWagon)new LightweightHttpsWagon());
        }
        if (roleHint.equals(FILE)) {
            return new FileWagon();
        }
        throw new RuntimeException("Role hint not supported: " + roleHint);
    }

    public void release(Wagon wagon) {
    }

    private LightweightHttpWagon setAuthenticator(LightweightHttpWagon wagon) {
        Field authenticator;
        try {
            authenticator = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws Exception {
                    Field field = LightweightHttpWagon.class.getDeclaredField("authenticator");
                    field.setAccessible(true);
                    return field;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ResolutionException("Could not manually set authenticator to accessible on " + LightweightHttpWagon.class.getName(), (Throwable)pae);
        }
        try {
            authenticator.set(wagon, new LightweightHttpWagonAuthenticator());
        }
        catch (Exception e) {
            throw new ResolutionException("Could not manually set authenticator on " + LightweightHttpWagon.class.getName(), (Throwable)e);
        }
        wagon.setPreemptiveAuthentication(true);
        return wagon;
    }
}

