/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Settings;
import org.jboss.forge.container.services.Exported;
import org.jboss.forge.container.util.Predicate;
import org.jboss.forge.dependencies.AddonDependencyResolver;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.DependencyException;
import org.jboss.forge.dependencies.DependencyQuery;
import org.jboss.forge.dependencies.DependencyRepository;
import org.jboss.forge.dependencies.DependencyResolver;
import org.jboss.forge.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.dependencies.builder.DependencyBuilder;
import org.jboss.forge.dependencies.builder.DependencyNodeBuilder;
import org.jboss.forge.maven.dependencies.AddonDependencySelector;
import org.jboss.forge.maven.dependencies.MavenContainer;
import org.jboss.forge.maven.dependencies.MavenConvertUtils;
import org.jboss.forge.maven.dependencies.MavenOperationException;
import org.jboss.forge.resource.FileResource;
import org.jboss.forge.resource.ResourceFactory;
import org.jboss.shrinkwrap.resolver.impl.maven.logging.LogTransferListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.collection.DependencyTraverser;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyRequest;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.resolution.DependencyResult;
import org.sonatype.aether.resolution.VersionRangeRequest;
import org.sonatype.aether.resolution.VersionRangeResult;
import org.sonatype.aether.transfer.TransferListener;
import org.sonatype.aether.util.graph.selector.ScopeDependencySelector;
import org.sonatype.aether.version.Version;

@Exported
public class MavenDependencyResolver
implements DependencyResolver,
AddonDependencyResolver {
    private MavenContainer container;
    private ResourceFactory factory;

    @Inject
    public MavenDependencyResolver(ResourceFactory factory, MavenContainer container) {
        this.container = container;
        this.factory = factory;
    }

    public Set<Dependency> resolveDependencies(DependencyQuery query) {
        DependencyResult artifacts;
        HashSet<Dependency> result = new HashSet<Dependency>();
        Predicate filter = query.getDependencyFilter();
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.container.getSettings();
        MavenRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        Artifact queryArtifact = MavenConvertUtils.coordinateToMavenArtifact(query.getCoordinate());
        List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
        if (remoteRepos.isEmpty()) {
            remoteRepos = MavenConvertUtils.convertToMavenRepos(Arrays.asList(new DependencyRepository("central", "http://repo1.maven.org/maven2")), settings);
        }
        remoteRepos.addAll(this.container.getEnabledRepositoriesFromProfile(settings));
        CollectRequest collectRequest = new CollectRequest(new org.sonatype.aether.graph.Dependency(queryArtifact, query.getScopeType()), remoteRepos);
        DependencyRequest request = new DependencyRequest(collectRequest, null);
        try {
            artifacts = system.resolveDependencies((RepositorySystemSession)session, request);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Could not resolve dependencies from Query [" + query + "] due to underlying exception", e);
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException(e);
        }
        DependencyNode root = artifacts.getRoot();
        for (DependencyNode node : root.getChildren()) {
            Dependency d = MavenConvertUtils.convertToDependency(this.factory, node);
            if (filter != null && !filter.accept((Object)d)) continue;
            result.add(d);
        }
        return result;
    }

    public List<Coordinate> resolveVersions(DependencyQuery query) {
        VersionRangeResult r = this.getVersions(query);
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        Predicate filter = query.getDependencyFilter();
        for (Version v : r.getVersions()) {
            CoordinateBuilder coord = CoordinateBuilder.create((Coordinate)query.getCoordinate()).setVersion(v.toString());
            DependencyBuilder versionedDep = DependencyBuilder.create().setCoordinate((Coordinate)coord);
            if (filter != null && !filter.accept((Object)versionedDep)) continue;
            result.add((Coordinate)coord);
        }
        return result;
    }

    VersionRangeResult getVersions(DependencyQuery query) {
        Coordinate dep = query.getCoordinate();
        try {
            String version = dep.getVersion();
            if (version == null || version.isEmpty()) {
                dep = CoordinateBuilder.create((Coordinate)dep).setVersion("[,)");
            } else if (!version.matches("(\\(|\\[).*?(\\)|\\])")) {
                dep = CoordinateBuilder.create((Coordinate)dep).setVersion("[" + version + "]");
            }
            RepositorySystem maven = this.container.getRepositorySystem();
            Settings settings = this.container.getSettings();
            MavenRepositorySystemSession session = this.container.setupRepoSession(maven, settings);
            Artifact artifact = MavenConvertUtils.coordinateToMavenArtifact(dep);
            List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
            if (remoteRepos.isEmpty()) {
                remoteRepos = MavenConvertUtils.convertToMavenRepos(Arrays.asList(new DependencyRepository("central", "http://repo1.maven.org/maven2")), settings);
            }
            remoteRepos.addAll(this.container.getEnabledRepositoriesFromProfile(settings));
            VersionRangeRequest rangeRequest = new VersionRangeRequest(artifact, remoteRepos, null);
            VersionRangeResult rangeResult = maven.resolveVersionRange((RepositorySystemSession)session, rangeRequest);
            return rangeResult;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to look up versions for [" + dep + "]", e);
        }
    }

    public Dependency resolveArtifact(DependencyQuery query) {
        RepositorySystem system = this.container.getRepositorySystem();
        Settings settings = this.container.getSettings();
        List<RemoteRepository> remoteRepos = MavenConvertUtils.convertToMavenRepos(query.getDependencyRepositories(), settings);
        if (remoteRepos.isEmpty()) {
            remoteRepos = MavenConvertUtils.convertToMavenRepos(Arrays.asList(new DependencyRepository("central", "http://repo1.maven.org/maven2")), settings);
        }
        remoteRepos.addAll(this.container.getEnabledRepositoriesFromProfile(settings));
        MavenRepositorySystemSession session = this.container.setupRepoSession(system, settings);
        Artifact queryArtifact = MavenConvertUtils.coordinateToMavenArtifact(query.getCoordinate());
        ArtifactRequest request = new ArtifactRequest(queryArtifact, remoteRepos, null);
        try {
            ArtifactResult resolvedArtifact = system.resolveArtifact((RepositorySystemSession)session, request);
            Artifact artifact = resolvedArtifact.getArtifact();
            FileResource artifactResource = (FileResource)this.factory.create(FileResource.class, (Object)artifact.getFile());
            return DependencyBuilder.create().setArtifact(artifactResource).setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setClassifier(artifact.getClassifier()).setPackaging(artifact.getExtension()).setVersion(artifact.getVersion());
        }
        catch (ArtifactResolutionException e) {
            throw new MavenOperationException(e);
        }
    }

    public org.jboss.forge.dependencies.DependencyNode resolveAddonDependencyHierarchy(final DependencyQuery query) {
        try {
            RepositorySystem system = this.container.getRepositorySystem();
            Settings settings = this.container.getSettings();
            MavenRepositorySystemSession session = this.container.setupRepoSession(system, settings);
            session.setTransferListener((TransferListener)new LogTransferListener());
            session.setDependencyTraverser(new DependencyTraverser(){

                public boolean traverseDependency(org.sonatype.aether.graph.Dependency dependency) {
                    boolean isForgeAddon = "forge-addon".equals(dependency.getArtifact().getClassifier());
                    if (!isForgeAddon && dependency.isOptional()) {
                        return false;
                    }
                    boolean result = query.getScopeType() != null ? query.getScopeType().equals(dependency.getScope()) : !"test".equals(dependency.getScope());
                    return result;
                }

                public DependencyTraverser deriveChildTraverser(DependencyCollectionContext context) {
                    return this;
                }
            });
            session.setDependencySelector((DependencySelector)new AddonDependencySelector());
            CoordinateBuilder coord = CoordinateBuilder.create((Coordinate)query.getCoordinate());
            Artifact queryArtifact = MavenConvertUtils.coordinateToMavenArtifact((Coordinate)coord);
            CollectRequest collectRequest = new CollectRequest(new org.sonatype.aether.graph.Dependency(queryArtifact, null), this.container.getEnabledRepositoriesFromProfile(settings));
            DependencyRequest dr = new DependencyRequest(collectRequest, null);
            DependencyResult result = system.resolveDependencies((RepositorySystemSession)session, dr);
            DependencyNodeBuilder hierarchy = MavenConvertUtils.toDependencyNode(this.factory, null, result.getRoot());
            return hierarchy;
        }
        catch (Exception e) {
            throw new DependencyException("Could not resolve dependencies for addon [" + query.getCoordinate() + "]", (Throwable)e);
        }
    }

    public org.jboss.forge.dependencies.DependencyNode resolveDependencyHierarchy(final DependencyQuery query) {
        try {
            RepositorySystem system = this.container.getRepositorySystem();
            Settings settings = this.container.getSettings();
            MavenRepositorySystemSession session = this.container.setupRepoSession(system, settings);
            session.setTransferListener((TransferListener)new LogTransferListener());
            session.setDependencyTraverser(new DependencyTraverser(){

                public boolean traverseDependency(org.sonatype.aether.graph.Dependency dependency) {
                    if (query.getScopeType() != null) {
                        return query.getScopeType().equals(dependency.getScope());
                    }
                    return !"test".equals(dependency.getScope());
                }

                public DependencyTraverser deriveChildTraverser(DependencyCollectionContext context) {
                    return this;
                }
            });
            session.setDependencySelector((DependencySelector)new ScopeDependencySelector(new String[]{"test"}));
            CoordinateBuilder coord = CoordinateBuilder.create((Coordinate)query.getCoordinate());
            Artifact queryArtifact = MavenConvertUtils.coordinateToMavenArtifact((Coordinate)coord);
            CollectRequest collectRequest = new CollectRequest(new org.sonatype.aether.graph.Dependency(queryArtifact, null), this.container.getEnabledRepositoriesFromProfile(settings));
            DependencyRequest dr = new DependencyRequest(collectRequest, null);
            DependencyResult result = system.resolveDependencies((RepositorySystemSession)session, dr);
            DependencyNodeBuilder hierarchy = MavenConvertUtils.toDependencyNode(this.factory, null, result.getRoot());
            return hierarchy;
        }
        catch (Exception e) {
            throw new DependencyException("Could not resolve dependencies for addon [" + query.getCoordinate() + "]", (Throwable)e);
        }
    }
}

