/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jboss.forge.facets.AbstractFaceted;
import org.jboss.forge.resource.Resource;
import org.jboss.forge.resource.ResourceFacet;
import org.jboss.forge.resource.ResourceFactory;
import org.jboss.forge.resource.ResourceFilter;

public abstract class AbstractResource<T>
extends AbstractFaceted<ResourceFacet>
implements Resource<T> {
    protected final ResourceFactory resourceFactory;
    protected Resource<?> parent;

    protected AbstractResource(ResourceFactory factory, Resource<?> parent) {
        if (factory == null) {
            throw new IllegalArgumentException("ResourceFactory must not be null.");
        }
        this.resourceFactory = factory;
        this.parent = parent;
    }

    @Override
    public ResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getParent() != null ? this.getParent().getFullyQualifiedName() + "/" + this.getName() : this.getName();
    }

    @Override
    public Resource<?> getParent() {
        return this.parent;
    }

    @Override
    public <R extends Resource<?>> R reify(Class<R> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (R)this;
        }
        return null;
    }

    protected abstract List<Resource<?>> doListResources();

    @Override
    public synchronized List<Resource<?>> listResources() {
        List<Resource<?>> resources = this.doListResources();
        Collections.sort(resources, new FQNResourceComparator());
        return resources;
    }

    @Override
    public synchronized List<Resource<?>> listResources(ResourceFilter filter) {
        ArrayList result = new ArrayList();
        for (Resource<?> resource : this.doListResources()) {
            if (!filter.accept(resource)) continue;
            result.add(resource);
        }
        Collections.sort(result, new FQNResourceComparator());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Resource) {
            return ((Resource)obj).getFullyQualifiedName().equals(this.getFullyQualifiedName());
        }
        return false;
    }

    public int hashCode() {
        return this.getFullyQualifiedName().hashCode();
    }

    public <F extends ResourceFacet> boolean supports(F facet) {
        return facet != null;
    }

    private static class FQNResourceComparator
    implements Comparator<Resource<?>> {
        private FQNResourceComparator() {
        }

        @Override
        public int compare(Resource<?> left, Resource<?> right) {
            return left.getFullyQualifiedName().compareTo(right.getFullyQualifiedName());
        }
    }
}

