/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.MethodHolder;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Types;

public class Methods {
    public static List<MethodSource<?>> implementAbstractMethods(MethodHolder<?> source, MethodHolderSource<?> target) {
        ArrayList methods = new ArrayList();
        for (Method<?, ?> method : source.getMethods()) {
            if (!method.isAbstract() || target.hasMethod(method)) continue;
            MethodSource<?> newMethod = target.addMethod(method);
            Methods.implementMethod(newMethod);
            methods.add(newMethod);
        }
        return methods;
    }

    public static List<MethodSource<?>> implementAbstractMethods(Class<?> source, MethodHolderSource<?> target) {
        ArrayList methods = new ArrayList();
        for (java.lang.reflect.Method m : source.getMethods()) {
            if (m.getDeclaringClass() == Object.class || !Modifier.isAbstract(m.getModifiers()) || target.getMethod(m.getName(), m.getParameterTypes()) != null) continue;
            MethodSource<?> newMethod = target.addMethod(m);
            Methods.implementMethod(newMethod);
            methods.add(newMethod);
        }
        return methods;
    }

    public static void implementMethod(MethodSource<?> source) {
        if (((JavaSource)source.getOrigin()).isInterface()) {
            source.setBody(null);
        } else {
            if (source.isNative()) {
                source.setNative(false);
            }
            source.setAbstract(false);
            if (source.isReturnTypeVoid()) {
                source.setBody("");
            } else {
                source.setBody("return " + Types.getDefaultValue(source.getReturnType().getName()) + ";");
            }
        }
    }

    public static String[] generateParameterNames(Class<?>[] parameterTypes) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Class<?> paramType : parameterTypes) {
            String name;
            String paramName = name = Methods.toParamName(paramType.getSimpleName());
            int idx = 1;
            while (parameterNames.contains(paramName)) {
                paramName = name + idx++;
            }
            parameterNames.add(paramName);
        }
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    static String toParamName(String type) {
        int i;
        if (Types.isBasicType(type) || Types.isJavaLang(type)) {
            return String.valueOf(type.charAt(0)).toLowerCase();
        }
        StringBuilder name = new StringBuilder(type);
        for (i = 0; i < name.length(); ++i) {
            if (Character.isUpperCase(name.charAt(i))) continue;
            --i;
            break;
        }
        if (i == 0) {
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
        } else if (i > 0) {
            name.replace(0, i, name.substring(0, i).toLowerCase());
        }
        return name.toString();
    }
}

