/*
 * Copyright 2012-2013 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Eclipse Public License version 1.0, available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.jboss.forge.roaster.model;

/**
 * Represents a parameter of a {@link Method}.
 * 
 * @author <a href="mailto:lincolnbaxter@gmail.com">Lincoln Baxter, III</a>
 * 
 */
public interface Parameter<O extends JavaType<O>> extends AnnotationTarget<O>, FinalCapable
{
   /**
    * @return the name of this parameter
    */
   String getName();

   /**
    * @return the type of this parameter
    */
   Type<O> getType();

   /**
    * @return if this parameter is declared as varargs (...)
    */
   boolean isVarArgs();
}
