/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Streams;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.spi.JavaParser;

public final class Roaster {
    private static List<JavaParser> parsers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JavaParser> getParsers() {
        Class<Roaster> clazz = Roaster.class;
        synchronized (Roaster.class) {
            if (parsers == null) {
                parsers = new ArrayList<JavaParser>();
                for (JavaParser p : ServiceLoader.load(JavaParser.class)) {
                    parsers.add(p);
                }
            }
            if (parsers.size() == 0) {
                throw new IllegalStateException("No instances of [" + JavaParser.class.getName() + "] were found on the classpath.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return parsers;
        }
    }

    public static <T extends JavaSource<?>> T create(Class<T> type) {
        for (JavaParser parser : Roaster.getParsers()) {
            T result = parser.create(type);
            if (result == null) continue;
            return result;
        }
        throw new ParserException("Cannot find JavaParserProvider capable of producing JavaSource of type " + type.getSimpleName(), new IllegalArgumentException(type.getName()));
    }

    public static JavaType<?> parse(File file) throws FileNotFoundException {
        return Roaster.parse(JavaType.class, file);
    }

    public static JavaType<?> parse(URL data) throws IOException {
        return Roaster.parse(JavaType.class, data);
    }

    public static JavaType<?> parse(InputStream data) {
        return Roaster.parse(JavaType.class, data);
    }

    public static JavaType<?> parse(char[] data) {
        return Roaster.parse(JavaType.class, data);
    }

    public static JavaType<?> parse(String data) {
        return Roaster.parse(JavaType.class, data);
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, URL url) throws IOException {
        return Roaster.internalParse(type, url.openStream());
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, File file) throws FileNotFoundException {
        return Roaster.internalParse(type, new FileInputStream(file));
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, char[] data) {
        return Roaster.parse(type, new String(data));
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, String data) {
        return Roaster.parse(type, Streams.fromString(data));
    }

    public static <T extends JavaType<?>> T parse(Class<T> type, InputStream data) {
        for (JavaParser parser : Roaster.getParsers()) {
            JavaType<?> source = parser.parse(data);
            if (type.isInstance(source)) {
                JavaType<?> result = source;
                return (T)result;
            }
            if (source == null) continue;
            throw new ParserException("Source does not represent a [" + type.getSimpleName() + "], instead was [" + source.getClass().getSimpleName() + "] - Cannot convert.");
        }
        throw new ParserException("Cannot find JavaParserProvider capable of parsing the requested data");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends JavaType<?>> T internalParse(Class<T> type, InputStream data) {
        try {
            T t = Roaster.parse(type, data);
            return t;
        }
        finally {
            Streams.closeQuietly(data);
        }
    }
}

