/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.util;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.roaster.model.Method;
import org.jboss.forge.roaster.model.MethodHolder;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodHolderSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.util.Types;

public class Methods {
    private Methods() {
        throw new IllegalAccessError("Utility class");
    }

    public static List<MethodSource<?>> implementAbstractMethods(MethodHolder<?> source, MethodHolderSource<?> target) {
        ArrayList methods = new ArrayList();
        for (Method<?, ?> method : source.getMethods()) {
            if (!method.isAbstract() || target.hasMethod(method)) continue;
            MethodSource<?> newMethod = target.addMethod(method);
            Methods.implementMethod(newMethod);
            Methods.removeAllAnnotations(newMethod);
            methods.add(newMethod);
        }
        return methods;
    }

    public static void removeAllAnnotations(MethodSource<?> source) {
        source.removeAllAnnotations();
        for (ParameterSource<?> parameterSource : source.getParameters()) {
            parameterSource.removeAllAnnotations();
        }
    }

    public static List<MethodSource<?>> implementAbstractMethods(Class<?> source, MethodHolderSource<?> target) {
        ArrayList methods = new ArrayList();
        for (java.lang.reflect.Method m : source.getMethods()) {
            if (m.getDeclaringClass() == Object.class || !Modifier.isAbstract(m.getModifiers()) || target.getMethod(m.getName(), (Class[])m.getParameterTypes()) != null) continue;
            MethodSource<?> newMethod = target.addMethod(m);
            Methods.implementMethod(newMethod);
            Methods.removeAllAnnotations(newMethod);
            methods.add(newMethod);
        }
        return methods;
    }

    public static void implementMethod(MethodSource<?> source) {
        if (((JavaSource)source.getOrigin()).isInterface()) {
            source.setBody(null);
        } else {
            if (source.isNative()) {
                source.setNative(false);
            }
            source.setAbstract(false);
            if (source.isReturnTypeVoid()) {
                source.setBody("");
            } else {
                source.setBody("return " + Types.getDefaultValue(source.getReturnType().getName()) + ";");
            }
        }
    }

    public static String[] generateParameterNames(Class<?>[] parameterTypes) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (Class<?> paramType : parameterTypes) {
            String name;
            String paramName = name = Methods.toParamName(paramType.getSimpleName());
            int index = 1;
            while (parameterNames.contains(paramName)) {
                paramName = name + index++;
            }
            parameterNames.add(paramName);
        }
        return parameterNames.toArray(new String[parameterNames.size()]);
    }

    private static String toParamName(String type) {
        if (Types.isBasicType(type) || Types.isJavaLang(type)) {
            return String.valueOf(type.charAt(0)).toLowerCase();
        }
        StringBuilder finalName = new StringBuilder(type.length());
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (Character.isUpperCase(c)) {
                finalName.append(Character.toLowerCase(c));
                continue;
            }
            if (!Character.isLowerCase(c)) continue;
            if (i > 1) {
                finalName.setCharAt(i - 1, Character.toUpperCase(finalName.charAt(i - 1)));
            }
            finalName.append(type.substring(i));
            break;
        }
        return finalName.toString();
    }
}

