/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster.model.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.roaster.ParserException;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.AST;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Block;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.CompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Javadoc;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MethodDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Modifier;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SimpleName;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Statement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.TypeParameter;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.Type;
import org.jboss.forge.roaster.model.TypeVariable;
import org.jboss.forge.roaster.model.Visibility;
import org.jboss.forge.roaster.model.VisibilityScoped;
import org.jboss.forge.roaster.model.ast.AnnotationAccessor;
import org.jboss.forge.roaster.model.ast.ModifierAccessor;
import org.jboss.forge.roaster.model.impl.JavaDocImpl;
import org.jboss.forge.roaster.model.impl.ParameterImpl;
import org.jboss.forge.roaster.model.impl.TypeImpl;
import org.jboss.forge.roaster.model.impl.TypeVariableImpl;
import org.jboss.forge.roaster.model.source.AnnotationSource;
import org.jboss.forge.roaster.model.source.AnnotationTargetSource;
import org.jboss.forge.roaster.model.source.Import;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaDocSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.source.ParameterSource;
import org.jboss.forge.roaster.model.source.TypeVariableSource;
import org.jboss.forge.roaster.model.source.VisibilityScopedSource;
import org.jboss.forge.roaster.model.util.Methods;
import org.jboss.forge.roaster.model.util.Strings;
import org.jboss.forge.roaster.model.util.Types;

public class MethodImpl<O extends JavaSource<O>>
implements MethodSource<O> {
    private final AnnotationAccessor<O, MethodSource<O>> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private O parent = null;
    private AST ast = null;
    private CompilationUnit cu = null;
    private final MethodDeclaration method;

    private void init(O parent) {
        this.parent = parent;
        this.cu = (CompilationUnit)parent.getInternal();
        this.ast = this.cu.getAST();
    }

    public MethodImpl(O parent) {
        this.init(parent);
        this.method = this.ast.newMethodDeclaration();
        this.method.setConstructor(false);
    }

    public MethodImpl(O parent, Object internal) {
        this.init(parent);
        this.method = (MethodDeclaration)internal;
    }

    public MethodImpl(O parent, Method reflectMethod) {
        this(parent);
        int mod = reflectMethod.getModifiers();
        if (Modifier.isPublic(mod)) {
            this.setPublic();
        } else if (Modifier.isProtected(mod)) {
            this.setProtected();
        } else if (Modifier.isPrivate(mod)) {
            this.setPrivate();
        }
        this.setAbstract(Modifier.isAbstract(mod));
        this.setSynchronized(Modifier.isSynchronized(mod));
        this.setNative(Modifier.isNative(mod));
        if (reflectMethod.getReturnType() == Void.TYPE) {
            this.setReturnTypeVoid();
        } else {
            this.setReturnType(reflectMethod.getReturnType());
        }
        this.setName(reflectMethod.getName());
        Class[] paramTypes = reflectMethod.getParameterTypes();
        String[] paramNames = Methods.generateParameterNames((Class[])paramTypes);
        for (int i = 0; i < paramTypes.length; ++i) {
            this.addParameter(paramTypes[i], paramNames[i]);
        }
        if (!this.isAbstract()) {
            Methods.implementMethod(this);
        }
    }

    public MethodImpl(O parent, String method) {
        MethodDeclaration subtree;
        this.init(parent);
        String stub = "public class Stub { " + method + " }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        MethodDeclaration newMethod = (MethodDeclaration)((MethodSource)methods.get(0)).getInternal();
        this.method = subtree = (MethodDeclaration)ASTNode.copySubtree(this.cu.getAST(), newMethod);
    }

    public String toSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(Visibility.PACKAGE_PRIVATE.equals((Object)this.getVisibility().scope()) ? "" : this.getVisibility().scope());
        signature.append(" ");
        signature.append(this.getName()).append("(");
        List<ParameterSource<O>> parameters = this.getParameters();
        for (ParameterSource<O> p : parameters) {
            signature.append(p.getType().getName());
            if (parameters.indexOf(p) >= parameters.size() - 1) continue;
            signature.append(", ");
        }
        signature.append(") : ").append(this.getReturnType() == null ? "void" : this.getReturnType().getName());
        return signature.toString();
    }

    public AnnotationSource<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, this.method);
    }

    public AnnotationSource<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, clazz.getSimpleName());
    }

    public AnnotationSource<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, className);
    }

    public List<AnnotationSource<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<O, MethodSource<O>>)this, this.method);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, this.method, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, this.method, type);
    }

    public MethodSource<O> removeAnnotation(Annotation<O> annotation) {
        return this.annotations.removeAnnotation(this, this.method, annotation);
    }

    public void removeAllAnnotations() {
        this.annotations.removeAllAnnotations(this.method);
    }

    public AnnotationSource<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, (Class<java.lang.annotation.Annotation>)type);
    }

    public AnnotationSource<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, MethodSource<O>>)this, (ASTNode)this.method, type);
    }

    public String getBody() {
        Block body = this.method.getBody();
        if (body != null) {
            StringBuilder result = new StringBuilder();
            List statements = (List)body.getStructuralProperty(Block.STATEMENTS_PROPERTY);
            for (Statement statement : statements) {
                result.append(statement).append(" ");
            }
            return result.toString().trim();
        }
        return null;
    }

    public MethodSource<O> setBody(String body) {
        if (body == null) {
            this.method.setBody(null);
        } else {
            List problems = Roaster.validateSnippet((String)body);
            if (problems.size() > 0) {
                throw new ParserException(problems);
            }
            String stub = "public class Stub { public void method() {" + body + "} }";
            JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
            List methods = temp.getMethods();
            Block block = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).getBody();
            block = (Block)ASTNode.copySubtree(this.method.getAST(), block);
            this.method.setBody(block);
        }
        return this;
    }

    public MethodSource<O> setConstructor(boolean constructor) {
        this.method.setConstructor(constructor);
        if (this.isConstructor()) {
            this.method.setName(this.ast.newSimpleName(this.parent.getName()));
        }
        return this;
    }

    public boolean isConstructor() {
        return this.method.isConstructor();
    }

    public Type<O> getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        return new TypeImpl<O>(this.parent, this.method.getReturnType2());
    }

    public boolean isReturnTypeVoid() {
        return this.getReturnType() == null || this.getReturnType().isType(Void.TYPE);
    }

    public MethodSource<O> setReturnType(Type<?> type) {
        return this.setReturnType(type.getQualifiedNameWithGenerics());
    }

    public MethodSource<O> setReturnType(Class<?> type) {
        return this.setReturnType(type.getCanonicalName());
    }

    public MethodSource<O> setReturnTypeVoid() {
        return this.setReturnType(Void.TYPE);
    }

    public MethodSource<O> setReturnType(String typeName) {
        String simpleName = Types.toSimpleName((String)typeName);
        O origin = this.getOrigin();
        if (!this.hasTypeVariable(typeName) && !Strings.areEqual((String)typeName, (String)simpleName) && origin.requiresImport(typeName)) {
            origin.addImport(typeName);
        }
        for (String genericType : Types.splitGenerics((String)typeName)) {
            if (this.hasTypeVariable(genericType) || !origin.requiresImport(genericType)) continue;
            origin.addImport(genericType);
        }
        String stub = "public class Stub { public " + simpleName + " method() {} }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type returnType = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).getReturnType2();
        returnType = (org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Type)ASTNode.copySubtree(this.method.getAST(), returnType);
        this.method.setReturnType2(returnType);
        return this;
    }

    public MethodSource<O> setReturnType(JavaType<?> type) {
        return this.setReturnType(type.getName());
    }

    public boolean isAbstract() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
    }

    public MethodSource<O> setAbstract(boolean abstrct) {
        if (abstrct) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
            this.setBody(null);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
            if (this.getBody() == null) {
                this.setBody("");
            }
        }
        return this;
    }

    public boolean isFinal() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    public MethodSource<O> setFinal(boolean finl) {
        if (finl) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
        return this;
    }

    public boolean isDefault() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.DEFAULT_KEYWORD);
    }

    public MethodSource<O> setDefault(boolean value) {
        if (value) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.DEFAULT_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.DEFAULT_KEYWORD);
        }
        return this;
    }

    public boolean isStatic() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public MethodSource<O> setStatic(boolean statc) {
        if (statc) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return this;
    }

    public MethodSource<O> setSynchronized(boolean value) {
        if (value) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
        }
        return this;
    }

    public boolean isSynchronized() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD);
    }

    public MethodSource<O> setNative(boolean value) {
        if (value) {
            this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.NATIVE_KEYWORD);
            this.setBody(null);
        } else {
            this.modifiers.removeModifier(this.method, Modifier.ModifierKeyword.NATIVE_KEYWORD);
            if (this.getBody() == null) {
                this.setBody("");
            }
        }
        return this;
    }

    public boolean isNative() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.NATIVE_KEYWORD);
    }

    public String getName() {
        return this.method.getName().getFullyQualifiedName();
    }

    public MethodSource<O> setName(String name) {
        if (this.method.isConstructor()) {
            throw new IllegalStateException("Cannot set the name of a constructor.");
        }
        this.method.setName(this.ast.newSimpleName(name));
        return this;
    }

    public MethodSource<O> setParameters(String parameters) {
        String stub = "public class Stub { public void method( " + parameters + " ) {} }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        List astParameters = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).parameters();
        this.method.parameters().clear();
        for (VariableDeclaration declaration : astParameters) {
            VariableDeclaration copy = (VariableDeclaration)ASTNode.copySubtree(this.method.getAST(), declaration);
            this.method.parameters().add(copy);
        }
        return this;
    }

    public List<ParameterSource<O>> getParameters() {
        ArrayList<ParameterImpl<O>> results = new ArrayList<ParameterImpl<O>>();
        List parameters = this.method.parameters();
        for (SingleVariableDeclaration param : parameters) {
            results.add(new ParameterImpl<O>(this.parent, param));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public MethodSource<O> setPackagePrivate() {
        this.modifiers.clearVisibility(this.method);
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public MethodSource<O> setPublic() {
        this.modifiers.clearVisibility(this.method);
        this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public MethodSource<O> setPrivate() {
        this.modifiers.clearVisibility(this.method);
        this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier(this.method, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public MethodSource<O> setProtected() {
        this.modifiers.clearVisibility(this.method);
        this.modifiers.addModifier(this.method, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public MethodSource<O> setVisibility(Visibility scope) {
        return (MethodSource)Visibility.set((VisibilityScopedSource)this, (Visibility)scope);
    }

    public String toString() {
        return this.method.toString();
    }

    public Object getInternal() {
        return this.method;
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodImpl other = (MethodImpl)obj;
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    public MethodSource<O> addThrows(Class<? extends Exception> type) {
        return this.addThrows(type.getCanonicalName());
    }

    public MethodSource<O> addThrows(String type) {
        String simpleTypeName = Types.toSimpleName((String)type);
        O origin = this.getOrigin();
        if (!Strings.areEqual((String)type, (String)simpleTypeName) && origin.requiresImport(type)) {
            origin.addImport(type);
        }
        SimpleName simpleName = this.method.getAST().newSimpleName(simpleTypeName);
        List list = (List)this.method.getStructuralProperty(MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
        list.add(this.method.getAST().newSimpleType(simpleName));
        return this;
    }

    public List<String> getThrownExceptions() {
        ArrayList<String> result = new ArrayList<String>();
        List list = (List)this.method.getStructuralProperty(MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
        for (Object object : list) {
            result.add(object.toString());
        }
        return result;
    }

    public MethodSource<O> removeThrows(Class<? extends Exception> type) {
        return this.removeThrows(type.getName());
    }

    public MethodSource<O> removeThrows(String type) {
        List list = (List)this.method.getStructuralProperty(MethodDeclaration.THROWN_EXCEPTION_TYPES_PROPERTY);
        for (Object object : list) {
            String thrown = object.toString();
            if (type.equals(thrown)) {
                list.remove(object);
                return this;
            }
            if (!Types.areEquivalent((String)type, (String)thrown)) continue;
            if (!Types.isQualified((String)type) && this.getOrigin().hasImport(thrown)) {
                list.remove(object);
                return this;
            }
            if (!Types.isQualified((String)thrown) && this.getOrigin().hasImport(type)) {
                list.remove(object);
                return this;
            }
            if (this.getOrigin().hasImport(type) || this.getOrigin().hasImport(thrown)) continue;
            list.remove(object);
            return this;
        }
        return this;
    }

    public List<TypeVariableSource<O>> getTypeVariables() {
        ArrayList<TypeVariableImpl<O>> result = new ArrayList<TypeVariableImpl<O>>();
        List typeParameters = this.method.typeParameters();
        if (typeParameters != null) {
            for (TypeParameter typeParameter : typeParameters) {
                result.add(new TypeVariableImpl<O>(this.parent, typeParameter));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public TypeVariableSource<O> getTypeVariable(String name) {
        List typeParameters = this.method.typeParameters();
        for (TypeParameter typeParameter : typeParameters) {
            if (!Strings.areEqual((String)name, (String)typeParameter.getName().getIdentifier())) continue;
            return new TypeVariableImpl<O>(this.parent, typeParameter);
        }
        return null;
    }

    public boolean hasTypeVariable(String name) {
        List typeParameters = this.method.typeParameters();
        for (TypeParameter typeParameter : typeParameters) {
            if (!Strings.areEqual((String)name, (String)typeParameter.getName().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    public TypeVariableSource<O> addTypeVariable() {
        TypeParameter tp2 = this.method.getAST().newTypeParameter();
        this.method.typeParameters().add(tp2);
        return new TypeVariableImpl<O>(this.parent, tp2);
    }

    public TypeVariableSource<O> addTypeVariable(String name) {
        return (TypeVariableSource)this.addTypeVariable().setName(name);
    }

    public MethodSource<O> removeTypeVariable(String name) {
        List typeParameters = this.method.typeParameters();
        Iterator iter = typeParameters.iterator();
        while (iter.hasNext()) {
            if (!Strings.areEqual((String)name, (String)((TypeParameter)iter.next()).getName().getIdentifier())) continue;
            iter.remove();
            break;
        }
        return this;
    }

    public MethodSource<O> removeTypeVariable(TypeVariable<?> typeVariable) {
        return this.removeTypeVariable(typeVariable.getName());
    }

    public ParameterSource<O> addParameter(Class<?> type, String name) {
        return this.addParameter(type.getCanonicalName(), name);
    }

    public ParameterSource<O> addParameter(JavaType<?> type, String name) {
        return this.addParameter(type.getQualifiedName(), name);
    }

    public ParameterSource<O> addParameter(String type, String name) {
        String resolvedType = type;
        if (!this.hasTypeVariable(type) && this.getOrigin().requiresImport(type)) {
            TypeImpl<O> innerType = new TypeImpl<O>(this.getOrigin(), null, type);
            Import imprt = this.getOrigin().addImport(innerType);
            resolvedType = imprt != null ? Types.rebuildGenericNameWithArrays((String)imprt.getSimpleName(), innerType) : Types.toSimpleName((String)type);
        }
        String stub = "public class Stub { public void method( " + resolvedType + " " + name + " ) {} }";
        JavaClassSource temp = (JavaClassSource)Roaster.parse((String)stub);
        List methods = temp.getMethods();
        List astParameters = ((MethodDeclaration)((MethodSource)methods.get(0)).getInternal()).parameters();
        ParameterImpl<O> param = null;
        for (VariableDeclaration declaration : astParameters) {
            VariableDeclaration copy = (VariableDeclaration)ASTNode.copySubtree(this.method.getAST(), declaration);
            this.method.parameters().add(copy);
            param = new ParameterImpl<O>(this.parent, copy);
        }
        return param;
    }

    public MethodSource<O> removeParameter(ParameterSource<O> parameter) {
        this.method.parameters().remove(parameter.getInternal());
        return this;
    }

    public MethodSource<O> removeParameter(Class<?> type, String name) {
        ParameterSource<O> parameter = null;
        for (ParameterSource<O> param : this.getParameters()) {
            if (!param.getType().isType(type) || !param.getName().equals(name)) continue;
            parameter = param;
            break;
        }
        if (parameter != null) {
            this.removeParameter(parameter);
        }
        return this;
    }

    public MethodSource<O> removeParameter(JavaType<?> type, String name) {
        ParameterSource<O> parameter = null;
        for (ParameterSource<O> param : this.getParameters()) {
            if (!param.getType().isType(type.getQualifiedName()) || !param.getName().equals(name)) continue;
            parameter = param;
            break;
        }
        if (parameter != null) {
            this.removeParameter(parameter);
        }
        return this;
    }

    public MethodSource<O> removeParameter(String type, String name) {
        ParameterSource<O> parameter = null;
        for (ParameterSource<O> param : this.getParameters()) {
            if (!param.getType().isType(type) || !param.getName().equals(name)) continue;
            parameter = param;
            break;
        }
        if (parameter != null) {
            this.removeParameter(parameter);
        }
        return this;
    }

    public boolean hasJavaDoc() {
        return this.method.getJavadoc() != null;
    }

    public MethodSource<O> removeJavaDoc() {
        this.method.setJavadoc(null);
        return this;
    }

    public JavaDocSource<MethodSource<O>> getJavaDoc() {
        Javadoc javadoc = this.method.getJavadoc();
        if (javadoc == null) {
            javadoc = this.method.getAST().newJavadoc();
            this.method.setJavadoc(javadoc);
        }
        return new JavaDocImpl<MethodSource<O>>(this, javadoc);
    }

    public int getStartPosition() {
        return this.method.getStartPosition();
    }

    public int getEndPosition() {
        int startPosition = this.getStartPosition();
        return startPosition == -1 ? -1 : startPosition + this.method.getLength();
    }

    public int getLineNumber() {
        return this.cu.getLineNumber(this.getStartPosition());
    }

    public int getColumnNumber() {
        return this.cu.getColumnNumber(this.getStartPosition());
    }
}

