/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.IAdapterFactoryExt;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Assert;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.AssertionFailedException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IAdapterFactory;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IAdapterManager;

public final class AdapterManager
implements IAdapterManager {
    private Map<String, Map<String, IAdapterFactory>> adapterLookup;
    private Map<IAdapterFactory, Map<String, Class<?>>> classLookup;
    private final Object classLookupLock = new Object();
    private Map<Class<?>, Class<?>[]> classSearchOrderLookup;
    private final HashMap<String, List<IAdapterFactory>> factories = new HashMap(5);
    private final ArrayList<IAdapterManagerProvider> lazyFactoryProviders = new ArrayList(1);
    private static final AdapterManager singleton = new AdapterManager();

    public static AdapterManager getDefault() {
        return singleton;
    }

    private AdapterManager() {
    }

    private void addFactoriesFor(String typeName, Map<String, IAdapterFactory> table) {
        List<IAdapterFactory> factoryList = this.getFactories().get(typeName);
        if (factoryList == null) {
            return;
        }
        int i = 0;
        int imax = factoryList.size();
        while (i < imax) {
            Object adapter;
            int n;
            int n2;
            Object[] objectArray;
            Object[] adapters;
            IAdapterFactory factory = factoryList.get(i);
            if (factory instanceof IAdapterFactoryExt) {
                objectArray = adapters = ((IAdapterFactoryExt)((Object)factory)).getAdapterNames();
                n2 = adapters.length;
                n = 0;
                while (n < n2) {
                    adapter = objectArray[n];
                    if (table.get(adapter) == null) {
                        table.put((String)adapter, factory);
                    }
                    ++n;
                }
            } else {
                objectArray = adapters = factory.getAdapterList();
                n2 = adapters.length;
                n = 0;
                while (n < n2) {
                    adapter = objectArray[n];
                    String adapterName = ((Class)adapter).getName();
                    if (table.get(adapterName) == null) {
                        table.put(adapterName, factory);
                    }
                    ++n;
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheClassLookup(IAdapterFactory factory, Class<?> clazz) {
        Object object = this.classLookupLock;
        synchronized (object) {
            Map<String, Class<?>> classes;
            Map<IAdapterFactory, Map<String, Class<?>>> lookup = this.classLookup;
            if (lookup == null) {
                lookup = new HashMap(4);
                this.classLookup = lookup;
            }
            if ((classes = lookup.get(factory)) == null) {
                classes = new HashMap(4);
                lookup.put(factory, classes);
            }
            classes.put(clazz.getName(), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> cachedClassForName(IAdapterFactory factory, String typeName) {
        Object object = this.classLookupLock;
        synchronized (object) {
            Map<String, Class<?>> classes;
            Class<?> clazz = null;
            Map<IAdapterFactory, Map<String, Class<?>>> lookup = this.classLookup;
            if (lookup != null && (classes = lookup.get(factory)) != null) {
                clazz = classes.get(typeName);
            }
            return clazz;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Class<?> classForName(IAdapterFactory factory, String typeName) {
        clazz = this.cachedClassForName(factory, typeName);
        if (clazz == null) {
            if (factory instanceof IAdapterFactoryExt) {
                factory = ((IAdapterFactoryExt)factory).loadFactory(false);
            }
            if (factory != null) {
                block9: {
                    try {
                        clazz = factory.getClass().getClassLoader().loadClass(typeName);
                        break block9;
                    }
                    catch (ClassNotFoundException v0) {
                        if (typeName == null) {
                            return null;
                        }
                        adapterList = factory.getAdapterList();
                        clazz = null;
                        var8_5 = adapterList;
                        var7_6 = adapterList.length;
                        var6_7 = 0;
                        ** while (var6_7 < var7_6)
                    }
lbl-1000:
                    // 1 sources

                    {
                        adapter = var8_5[var6_7];
                        if (typeName.equals(adapter.getName())) {
                            clazz = adapter;
                            break;
                        }
                        ++var6_7;
                        continue;
                    }
lbl24:
                    // 2 sources

                    if (clazz == null) {
                        return null;
                    }
                }
                this.cacheClassLookup(factory, clazz);
            }
        }
        return clazz;
    }

    public String[] computeAdapterTypes(Class<? extends Object> adaptable) {
        Set<String> types = this.getFactories(adaptable).keySet();
        return types.toArray(new String[types.size()]);
    }

    private Map<String, IAdapterFactory> getFactories(Class<? extends Object> adaptable) {
        Map<String, IAdapterFactory> table;
        Map<String, Map<String, IAdapterFactory>> lookup = this.adapterLookup;
        if (lookup == null) {
            lookup = Collections.synchronizedMap(new HashMap(30));
            this.adapterLookup = lookup;
        }
        if ((table = lookup.get(adaptable.getName())) == null) {
            Class<? extends Object>[] classes;
            table = new HashMap<String, IAdapterFactory>(4);
            Class<? extends Object>[] classArray = classes = this.computeClassOrder(adaptable);
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<? extends Object> cl = classArray[n2];
                this.addFactoriesFor(cl.getName(), table);
                ++n2;
            }
            lookup.put(adaptable.getName(), table);
        }
        return table;
    }

    @Override
    public <T> Class<? super T>[] computeClassOrder(Class<T> adaptable) {
        Class<?>[] classes = null;
        Map<Class<Object>, Object> lookup = this.classSearchOrderLookup;
        if (lookup == null) {
            lookup = Collections.synchronizedMap(new HashMap());
            this.classSearchOrderLookup = lookup;
        } else {
            classes = lookup.get(adaptable);
        }
        if (classes == null) {
            classes = this.doComputeClassOrder(adaptable);
            lookup.put(adaptable, classes);
        }
        return classes;
    }

    private Class<?>[] doComputeClassOrder(Class<?> adaptable) {
        Class[] classHierarchy;
        ArrayList classes = new ArrayList();
        Class<?> clazz = adaptable;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            classes.add(clazz);
            clazz = clazz.getSuperclass();
        }
        Class[] classArray = classHierarchy = classes.toArray(new Class[classes.size()]);
        int n = classHierarchy.length;
        int n2 = 0;
        while (n2 < n) {
            Class cl = classArray[n2];
            this.computeInterfaceOrder(cl.getInterfaces(), classes, seen);
            ++n2;
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private void computeInterfaceOrder(Class<?>[] interfaces, Collection<Class<?>> classes, Set<Class<?>> seen) {
        ArrayList newInterfaces = new ArrayList(interfaces.length);
        Class<?>[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (seen.add(clazz)) {
                classes.add(clazz);
                newInterfaces.add(clazz);
            }
            ++n2;
        }
        for (Class clazz : newInterfaces) {
            this.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
        }
    }

    public synchronized void flushLookup() {
        this.adapterLookup = null;
        this.classLookup = null;
        this.classSearchOrderLookup = null;
    }

    @Override
    public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        Assert.isNotNull(adaptable);
        Assert.isNotNull(adapterType);
        String adapterTypeName = adapterType.getName();
        IAdapterFactory factory = this.getFactories(adaptable.getClass()).get(adapterTypeName);
        Object result = null;
        if (factory != null) {
            result = factory.getAdapter(adaptable, adapterType);
        }
        if (result == null && adapterType.isInstance(adaptable)) {
            return (T)adaptable;
        }
        if (result == null || adapterType.isInstance(result)) {
            return (T)result;
        }
        throw new AssertionFailedException("Adapter factory " + factory + " returned " + result.getClass().getName() + " that is not an instance of " + adapterTypeName);
    }

    @Override
    public Object getAdapter(Object adaptable, String adapterType) {
        Assert.isNotNull(adaptable);
        Assert.isNotNull(adapterType);
        return this.getAdapter(adaptable, adapterType, false);
    }

    private Object getAdapter(Object adaptable, String adapterType, boolean force) {
        Class<?> clazz;
        IAdapterFactory factory = this.getFactories(adaptable.getClass()).get(adapterType);
        if (force && factory instanceof IAdapterFactoryExt) {
            factory = ((IAdapterFactoryExt)((Object)factory)).loadFactory(true);
        }
        Object result = null;
        if (factory != null && (clazz = this.classForName(factory, adapterType)) != null) {
            result = factory.getAdapter(adaptable, clazz);
        }
        if (result == null && adaptable.getClass().getName().equals(adapterType)) {
            return adaptable;
        }
        return result;
    }

    @Override
    public boolean hasAdapter(Object adaptable, String adapterTypeName) {
        return this.getFactories(adaptable.getClass()).get(adapterTypeName) != null;
    }

    @Override
    public int queryAdapter(Object adaptable, String adapterTypeName) {
        IAdapterFactory factory = this.getFactories(adaptable.getClass()).get(adapterTypeName);
        if (factory == null) {
            return 0;
        }
        if (factory instanceof IAdapterFactoryExt && (factory = ((IAdapterFactoryExt)((Object)factory)).loadFactory(false)) == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public Object loadAdapter(Object adaptable, String adapterTypeName) {
        return this.getAdapter(adaptable, adapterTypeName, true);
    }

    @Override
    public synchronized void registerAdapters(IAdapterFactory factory, Class<?> adaptable) {
        this.registerFactory(factory, adaptable.getName());
        this.flushLookup();
    }

    public void registerFactory(IAdapterFactory factory, String adaptableType) {
        List<IAdapterFactory> list = this.factories.get(adaptableType);
        if (list == null) {
            list = new ArrayList<IAdapterFactory>(5);
            this.factories.put(adaptableType, list);
        }
        list.add(factory);
    }

    @Override
    public synchronized void unregisterAdapters(IAdapterFactory factory) {
        for (List<IAdapterFactory> list : this.factories.values()) {
            list.remove(factory);
        }
        this.flushLookup();
    }

    @Override
    public synchronized void unregisterAdapters(IAdapterFactory factory, Class<?> adaptable) {
        List<IAdapterFactory> factoryList = this.factories.get(adaptable.getName());
        if (factoryList == null) {
            return;
        }
        factoryList.remove(factory);
        this.flushLookup();
    }

    public synchronized void unregisterAllAdapters() {
        this.factories.clear();
        this.flushLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLazyFactoryProvider(IAdapterManagerProvider factoryProvider) {
        ArrayList<IAdapterManagerProvider> arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            this.lazyFactoryProviders.add(factoryProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterLazyFactoryProvider(IAdapterManagerProvider factoryProvider) {
        ArrayList<IAdapterManagerProvider> arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            return this.lazyFactoryProviders.remove(factoryProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, List<IAdapterFactory>> getFactories() {
        ArrayList<IAdapterManagerProvider> arrayList = this.lazyFactoryProviders;
        synchronized (arrayList) {
            while (this.lazyFactoryProviders.size() > 0) {
                IAdapterManagerProvider provider = this.lazyFactoryProviders.remove(0);
                if (!provider.addFactories(this)) continue;
                this.flushLookup();
            }
        }
        return this.factories;
    }
}

