/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Assert;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Status;

public class MultiStatus
extends Status {
    private final List<IStatus> children = new ArrayList<IStatus>();

    public MultiStatus(String pluginId, int code, IStatus[] newChildren, String message, Throwable exception) {
        this(pluginId, code, message, exception);
        Assert.isLegal(newChildren != null);
        this.addAllInternal(newChildren);
    }

    public MultiStatus(String pluginId, int code, String message, Throwable exception) {
        super(0, pluginId, code, message, exception);
    }

    public void add(IStatus status) {
        Assert.isLegal(status != null);
        this.children.add(status);
        int newSev = status.getSeverity();
        if (newSev > this.getSeverity()) {
            this.setSeverity(newSev);
        }
    }

    public void addAll(IStatus status) {
        Assert.isLegal(status != null);
        this.addAllInternal(status.getChildren());
    }

    private void addAllInternal(IStatus[] newChildren) {
        int maxSeverity = this.getSeverity();
        IStatus[] iStatusArray = newChildren;
        int n = newChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            Assert.isLegal(child != null);
            int severity = child.getSeverity();
            if (severity > maxSeverity) {
                maxSeverity = severity;
            }
            ++n2;
        }
        this.children.addAll(Arrays.asList(newChildren));
        this.setSeverity(maxSeverity);
    }

    @Override
    public IStatus[] getChildren() {
        return this.children.toArray(new IStatus[0]);
    }

    @Override
    public boolean isMultiStatus() {
        return true;
    }

    public void merge(IStatus status) {
        Assert.isLegal(status != null);
        if (!status.isMultiStatus()) {
            this.add(status);
        } else {
            this.addAll(status);
        }
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(" ", String.valueOf(super.toString()) + " children=[", "]");
        for (IStatus child : this.children) {
            joiner.add(child.toString());
        }
        return joiner.toString();
    }
}

