/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.core.runtime;

import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.Activator;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.CommonMessages;
import org.jboss.forge.roaster._shade.org.eclipse.core.internal.runtime.RuntimeLog;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Assert;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.ISafeRunnable;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.MultiStatus;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.OperationCanceledException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.Status;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;

public final class SafeRunner {
    public static void run(ISafeRunnable code) {
        Assert.isNotNull(code);
        try {
            code.run();
        }
        catch (AssertionError | Exception | LinkageError e) {
            SafeRunner.handleException(code, (Throwable)e);
        }
    }

    private static void handleException(ISafeRunnable code, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            Status status;
            Activator activator = Activator.getDefault();
            String pluginId = null;
            if (activator != null) {
                pluginId = activator.getBundleId(code);
            }
            if (pluginId == null) {
                pluginId = "org.jboss.forge.roaster._shade.org.eclipse.equinox.common";
            }
            String message = NLS.bind(CommonMessages.meta_pluginProblems, pluginId);
            if (e instanceof CoreException) {
                status = new MultiStatus(pluginId, 2, message, e);
                status.merge(((CoreException)e).getStatus());
            } else {
                status = new Status(4, pluginId, 2, message, e);
            }
            if (!RuntimeLog.isEmpty()) {
                RuntimeLog.log(status);
            } else {
                e.printStackTrace();
            }
        }
        code.handleException(e);
    }
}

