/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.JrtFileSystem;

class JrtFileSystemWithOlderRelease
extends JrtFileSystem {
    final String release;
    String releaseInHex = null;
    private String[] subReleases = null;
    protected Path modulePath = null;

    JrtFileSystemWithOlderRelease(File jrt, String release) throws IOException {
        super(jrt);
        this.release = release;
        this.initialize(jrt, release);
    }

    @Override
    void initialize(File jdk) throws IOException {
    }

    void initialize(File jdk, String rel) throws IOException {
        super.initialize(jdk);
        this.fs = null;
        this.releaseInHex = Integer.toHexString(Integer.parseInt(this.release)).toUpperCase();
        Path ct = Paths.get(this.jdkHome, "lib", "ct.sym");
        if (!Files.exists(ct, new LinkOption[0])) {
            return;
        }
        URI uri = URI.create("jar:file:" + ct.toUri().getRawPath());
        try {
            this.fs = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {}
        if (this.fs == null) {
            HashMap env = new HashMap();
            try {
                this.fs = FileSystems.newFileSystem(uri, env);
            }
            catch (IOException iOException) {
                return;
            }
        }
        Path releasePath = this.fs.getPath("/", new String[0]);
        if (!Files.exists(this.fs.getPath(this.releaseInHex, new String[0]), new LinkOption[0]) || Files.exists(this.fs.getPath(this.releaseInHex, "system-modules"), new LinkOption[0])) {
            this.fs = null;
        }
        if (this.release != null) {
            ArrayList<String> sub = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(releasePath);){
                    for (Path subdir : stream) {
                        String r = JRTUtil.sanitizedFileName(subdir);
                        if (!r.contains(this.releaseInHex)) continue;
                        sub.add(r);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.subReleases = sub.toArray(new String[sub.size()]);
        }
    }

    @Override
    void walkModuleImage(final JRTUtil.JrtFileVisitor<Path> visitor, final int notify) throws IOException {
        if (this.subReleases != null && this.subReleases.length > 0) {
            String[] stringArray = this.subReleases;
            int n = this.subReleases.length;
            int n2 = 0;
            while (n2 < n) {
                String rel = stringArray[n2];
                Path p = this.fs.getPath(rel, new String[0]);
                Files.walkFileTree(p, (FileVisitor<? super Path>)new JRTUtil.AbstractFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        int count = dir.getNameCount();
                        if (count == 1) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (count == 2) {
                            Path mod = dir.getName(1);
                            if (JRTUtil.MODULE_TO_LOAD != null && JRTUtil.MODULE_TO_LOAD.length() > 0 && JRTUtil.MODULE_TO_LOAD.indexOf(mod.toString()) == -1) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            return (notify & JRTUtil.NOTIFY_MODULES) == 0 ? FileVisitResult.CONTINUE : visitor.visitModule(dir, JRTUtil.sanitizedFileName(mod));
                        }
                        if ((notify & JRTUtil.NOTIFY_PACKAGES) == 0) {
                            return FileVisitResult.CONTINUE;
                        }
                        return visitor.visitPackage(dir.subpath(2, count), dir.getName(1), attrs);
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if ((notify & JRTUtil.NOTIFY_FILES) == 0) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (file.getNameCount() == 3) {
                            JrtFileSystemWithOlderRelease.this.cachePackage("", file.getName(1).toString());
                        }
                        return visitor.visitFile(file.subpath(2, file.getNameCount()), file.getName(1), attrs);
                    }
                });
                ++n2;
            }
        }
    }
}

