/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.matching;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.forge.roaster._shade.org.eclipse.core.resources.IContainer;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.CoreException;
import org.jboss.forge.roaster._shade.org.eclipse.core.runtime.IPath;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IJavaProject;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IModuleDescription;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IPackageDeclaration;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.JavaModelException;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.CharOperation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IModule;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.ClasspathEntry;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaElement;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModel;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaModelManager;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JavaProject;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.NameLookup;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.search.matching.ClasspathSourceDirectory;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.internal.core.util.Util;

public class JavaSearchNameEnvironment
implements IModuleAwareNameEnvironment,
SuffixConstants {
    LinkedHashSet<ClasspathLocation> locationSet;
    Map<String, IModuleDescription> modules;
    private boolean modulesComputed = false;
    Map<String, ClasspathLocation> moduleLocations;
    Map<String, LinkedHashSet<ClasspathLocation>> moduleToClassPathLocations;
    Map<String, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit> workingCopies;

    public JavaSearchNameEnvironment(IJavaProject javaProject, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit[] copies) {
        if (JavaSearchNameEnvironment.isComplianceJava9OrHigher(javaProject)) {
            this.moduleLocations = new HashMap<String, ClasspathLocation>();
            this.moduleToClassPathLocations = new HashMap<String, LinkedHashSet<ClasspathLocation>>();
        }
        this.modules = new HashMap<String, IModuleDescription>();
        this.locationSet = this.computeClasspathLocations((JavaProject)javaProject);
        this.workingCopies = JavaSearchNameEnvironment.getWorkingCopyMap(copies);
    }

    public static Map<String, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit> getWorkingCopyMap(org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit[] copies) {
        int length = copies == null ? 0 : copies.length;
        HashMap<String, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit> result = new HashMap<String, org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit>(length);
        try {
            if (copies != null) {
                int i = 0;
                while (i < length) {
                    org.jboss.forge.roaster._shade.org.eclipse.jdt.core.ICompilationUnit workingCopy = copies[i];
                    IPackageDeclaration[] pkgs = workingCopy.getPackageDeclarations();
                    String pkg = pkgs.length > 0 ? pkgs[0].getElementName() : "";
                    String cuName = workingCopy.getElementName();
                    String mainTypeName = Util.getNameWithoutJavaLikeExtension(cuName);
                    String qualifiedMainTypeName = pkg.length() == 0 ? mainTypeName : String.valueOf(pkg.replace('.', '/')) + '/' + mainTypeName;
                    result.put(qualifiedMainTypeName, workingCopy);
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    @Override
    public void cleanup() {
        this.locationSet.clear();
    }

    void addProjectClassPath(JavaProject javaProject) {
        LinkedHashSet<ClasspathLocation> locations = this.computeClasspathLocations(javaProject);
        if (locations != null) {
            this.locationSet.addAll(locations);
        }
    }

    private LinkedHashSet<ClasspathLocation> computeClasspathLocations(JavaProject javaProject) {
        IPackageFragmentRoot[] roots = null;
        try {
            roots = javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        IModuleDescription imd = null;
        try {
            imd = javaProject.getModuleDescription();
        }
        catch (JavaModelException javaModelException) {}
        LinkedHashSet<ClasspathLocation> locations = new LinkedHashSet<ClasspathLocation>();
        int length = roots.length;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        int i = 0;
        while (i < length) {
            ClasspathLocation cp = this.mapToClassPathLocation(manager, (PackageFragmentRoot)roots[i], imd);
            if (cp != null) {
                locations.add(cp);
            }
            ++i;
        }
        return locations;
    }

    private void computeModules() {
        if (!this.modulesComputed) {
            this.modulesComputed = true;
            JavaElementRequestor requestor = new JavaElementRequestor();
            try {
                IModuleDescription[] mods;
                JavaModelManager.getModulePathManager().seekModule(CharOperation.ALL_PREFIX, true, requestor);
                IModuleDescription[] iModuleDescriptionArray = mods = requestor.getModules();
                int n = mods.length;
                int n2 = 0;
                while (n2 < n) {
                    IModuleDescription mod = iModuleDescriptionArray[n2];
                    this.modules.putIfAbsent(mod.getElementName(), mod);
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private ClasspathLocation mapToClassPathLocation(JavaModelManager manager, PackageFragmentRoot root, IModuleDescription defaultModule) {
        ClasspathLocation cp = null;
        IPath path = root.getPath();
        try {
            if (root.isArchive()) {
                ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                IJavaProject project = (IJavaProject)root.getParent();
                String compliance = project.getOption("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.compliance", true);
                cp = root instanceof JrtPackageFragmentRoot ? ClasspathLocation.forJrtSystem(path.toOSString(), rawClasspathEntry.getAccessRuleSet(), ClasspathEntry.getExternalAnnotationPath(rawClasspathEntry, project.getProject(), true), compliance) : ClasspathLocation.forLibrary(manager.getZipFile(path), rawClasspathEntry.getAccessRuleSet(), ClasspathEntry.getExternalAnnotationPath(rawClasspathEntry, ((IJavaProject)root.getParent()).getProject(), true), rawClasspathEntry.isModular(), compliance);
            } else {
                Object target = JavaModel.getTarget(path, true);
                if (target != null) {
                    if (root.getKind() == 1) {
                        cp = new ClasspathSourceDirectory((IContainer)target, root.fullExclusionPatternChars(), root.fullInclusionPatternChars());
                    } else {
                        ClasspathEntry rawClasspathEntry = (ClasspathEntry)root.getRawClasspathEntry();
                        cp = ClasspathLocation.forBinaryFolder((IContainer)target, false, rawClasspathEntry.getAccessRuleSet(), ClasspathEntry.getExternalAnnotationPath(rawClasspathEntry, ((IJavaProject)root.getParent()).getProject(), true), rawClasspathEntry.isModular());
                    }
                }
            }
        }
        catch (CoreException coreException) {}
        if (JavaSearchNameEnvironment.isComplianceJava9OrHigher(root.getJavaProject())) {
            this.addModuleClassPathInfo(root, defaultModule, cp);
        }
        return cp;
    }

    private void addModuleClassPathInfo(PackageFragmentRoot root, IModuleDescription defaultModule, ClasspathLocation cp) {
        IModuleDescription imd = root.getModuleDescription();
        if (imd != null) {
            String moduleName = this.addModuleClassPathInfo(cp, imd);
            if (moduleName != null) {
                this.modules.put(moduleName, imd);
            }
            if (this.moduleLocations != null) {
                this.moduleLocations.put(moduleName, cp);
            }
        } else if (defaultModule != null) {
            this.addModuleClassPathInfo(cp, defaultModule);
        }
    }

    private String addModuleClassPathInfo(ClasspathLocation cp, IModuleDescription imd) {
        char[] name;
        IModule mod = NameLookup.getModuleDescriptionInfo(imd);
        String moduleName = null;
        if (mod != null && (name = mod.name()) != null) {
            moduleName = new String(name);
            cp.setModule(mod);
            this.addClassPathToModule(moduleName, cp);
        }
        return moduleName;
    }

    private void addClassPathToModule(String moduleName, ClasspathLocation cp) {
        if (this.moduleToClassPathLocations != null) {
            LinkedHashSet<ClasspathLocation> l = this.moduleToClassPathLocations.get(moduleName);
            if (l == null) {
                l = new LinkedHashSet();
                this.moduleToClassPathLocations.put(moduleName, l);
            }
            l.add(cp);
        }
    }

    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName, IModuleAwareNameEnvironment.LookupStrategy strategy, String moduleName) {
        String binaryFileName = null;
        String qBinaryFileName = null;
        String sourceFileName = null;
        String qSourceFileName = null;
        String qPackageName = null;
        NameEnvironmentAnswer suggestedAnswer = null;
        Iterator<ClasspathLocation> iter = this.getLocationsFor(moduleName);
        while (iter.hasNext()) {
            NameEnvironmentAnswer answer;
            ClasspathLocation location = iter.next();
            if (!strategy.matches(location, ClasspathLocation::hasModule)) continue;
            if (location instanceof ClasspathSourceDirectory) {
                ICompilationUnit workingCopy;
                if (sourceFileName == null) {
                    sourceFileName = qSourceFileName = qualifiedTypeName;
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        int typeNameStart = qSourceFileName.length() - typeName.length;
                        qPackageName = qSourceFileName.substring(0, typeNameStart - 1);
                        sourceFileName = qSourceFileName.substring(typeNameStart);
                    }
                }
                answer = (workingCopy = (ICompilationUnit)((Object)this.workingCopies.get(qualifiedTypeName))) != null ? new NameEnvironmentAnswer(workingCopy, null) : location.findClass(sourceFileName, qPackageName, moduleName, qSourceFileName, false, null);
            } else {
                if (binaryFileName == null) {
                    binaryFileName = qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
                    qPackageName = "";
                    if (qualifiedTypeName.length() > typeName.length) {
                        int typeNameStart = qBinaryFileName.length() - typeName.length - 6;
                        qPackageName = qBinaryFileName.substring(0, typeNameStart - 1);
                        binaryFileName = qBinaryFileName.substring(typeNameStart);
                    }
                }
                answer = location.findClass(binaryFileName, qPackageName, moduleName, qBinaryFileName, false, this.moduleLocations != null ? this.moduleLocations::containsKey : null);
            }
            if (answer == null) continue;
            if (!answer.ignoreIfBetter()) {
                if (!answer.isBetter(suggestedAnswer)) continue;
                return answer;
            }
            if (!answer.isBetter(suggestedAnswer)) continue;
            suggestedAnswer = answer;
        }
        if (suggestedAnswer != null) {
            return suggestedAnswer;
        }
        return null;
    }

    private Iterator<ClasspathLocation> getLocationsFor(String moduleName) {
        LinkedHashSet<ClasspathLocation> l;
        if (moduleName != null && (l = this.moduleToClassPathLocations.get(moduleName)) != null && l.size() > 0) {
            return l.iterator();
        }
        return this.locationSet.iterator();
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        if (typeName != null) {
            return this.findClass(new String(CharOperation.concatWith(packageName, typeName, '/')), typeName, IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        if (compoundName != null) {
            return this.findClass(new String(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1], IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
        }
        return null;
    }

    @Override
    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        String qualifiedPackageName = String.valueOf(CharOperation.concatWith(packageName, '/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        if (strategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            if (this.moduleToClassPathLocations != null) {
                List l;
                String moduleNameString = String.valueOf(moduleName);
                LinkedHashSet<ClasspathLocation> cpl = this.moduleToClassPathLocations.get(moduleNameString);
                List list = l = cpl != null ? cpl.stream().collect(Collectors.toList()) : null;
                if (l != null) {
                    for (ClasspathLocation cp : l) {
                        if (!cp.isPackage(qualifiedPackageName, moduleNameString)) continue;
                        return new char[][]{moduleName};
                    }
                }
            }
            return null;
        }
        char[][] moduleNames = CharOperation.NO_CHAR_CHAR;
        for (ClasspathLocation location : this.locationSet) {
            char[][] mNames;
            if (!strategy.matches(location, ClasspathLocation::hasModule) || !location.isPackage(qualifiedPackageName, null) || (mNames = location.getModulesDeclaringPackage(qualifiedPackageName, null)) == null || mNames.length == 0) continue;
            moduleNames = CharOperation.arrayConcat(moduleNames, mNames);
        }
        return moduleNames == CharOperation.NO_CHAR_CHAR ? null : moduleNames;
    }

    @Override
    public char[][] listPackages(char[] moduleName) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Named: {
                if (this.moduleLocations != null) {
                    ClasspathLocation location = this.moduleLocations.get(String.valueOf(moduleName));
                    if (location == null) {
                        return CharOperation.NO_CHAR_CHAR;
                    }
                    return location.listPackages();
                }
                return CharOperation.NO_CHAR_CHAR;
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    @Override
    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        String qualifiedPackageNameString = String.valueOf(CharOperation.concatWith(qualifiedPackageName, '/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        String moduleNameString = IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName);
        if (strategy == IModuleAwareNameEnvironment.LookupStrategy.Named) {
            ClasspathLocation location;
            if (this.moduleLocations != null && (location = this.moduleLocations.get(moduleNameString)) != null) {
                return location.hasCompilationUnit(qualifiedPackageNameString, moduleNameString);
            }
        } else {
            for (ClasspathLocation location : this.locationSet) {
                if (!strategy.matches(location, ClasspathLocation::hasModule) || !location.hasCompilationUnit(qualifiedPackageNameString, moduleNameString)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public IModule getModule(char[] moduleName) {
        this.computeModules();
        IModuleDescription moduleDesc = this.modules.get(new String(moduleName));
        IModule module = null;
        try {
            if (moduleDesc != null) {
                module = (IModule)((JavaElement)((Object)moduleDesc)).getElementInfo();
            }
        }
        catch (JavaModelException javaModelException) {}
        return module;
    }

    @Override
    public char[][] getAllAutomaticModules() {
        if (this.moduleLocations == null || this.moduleLocations.size() == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        Set set = this.moduleLocations.values().stream().map(e -> e.getModule()).filter(m -> m != null && m.isAutomatic()).map(m -> m.name()).collect(Collectors.toSet());
        return (char[][])set.toArray((T[])new char[set.size()][]);
    }

    private static boolean isComplianceJava9OrHigher(IJavaProject javaProject) {
        if (javaProject == null) {
            return false;
        }
        return CompilerOptions.versionToJdkLevel(javaProject.getOption("org.jboss.forge.roaster._shade.org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L;
    }
}

