/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.roaster._shade.org.eclipse.osgi.framework.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.internal.messages.Msg;
import org.jboss.forge.roaster._shade.org.eclipse.osgi.util.NLS;

public class CaseInsensitiveDictionaryMap<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    final Map<Object, V> map;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private transient Set<K> keySet = null;

    public CaseInsensitiveDictionaryMap() {
        this.map = new HashMap<Object, V>();
    }

    public CaseInsensitiveDictionaryMap(int initialCapacity) {
        this.map = new HashMap<Object, V>(initialCapacity);
    }

    public CaseInsensitiveDictionaryMap(Dictionary<? extends K, ? extends V> dictionary) {
        this(CaseInsensitiveDictionaryMap.initialCapacity(dictionary.size()));
        Enumeration<K> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            V value;
            K key = keys.nextElement();
            if (key == null || (value = dictionary.get(key)) == null || this.put(key, value) == null) continue;
            throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, key));
        }
    }

    public CaseInsensitiveDictionaryMap(Map<? extends K, ? extends V> map) {
        this(CaseInsensitiveDictionaryMap.initialCapacity(map.size()));
        for (Map.Entry<K, V> e : map.entrySet()) {
            V value;
            K key = e.getKey();
            if (key == null || (value = e.getValue()) == null || this.put(key, value) == null) continue;
            throw new IllegalArgumentException(NLS.bind(Msg.HEADER_DUPLICATE_KEY_EXCEPTION, key));
        }
    }

    protected static int initialCapacity(int size) {
        return Math.max((int)((float)size / 0.75f) + 1, 16);
    }

    @Override
    public Enumeration<K> keys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public Enumeration<V> elements() {
        return Collections.enumeration(this.values());
    }

    @Override
    public V get(Object key) {
        return this.map.get(this.keyWrap(key));
    }

    private Object keyWrap(Object key) {
        if (key instanceof String) {
            return new CaseInsensitiveKey((String)key);
        }
        return key;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        Objects.requireNonNull(value);
        if (key instanceof String) {
            Object wrappedKey = this.keyWrap(((String)key).intern());
            V previous = this.map.remove(wrappedKey);
            this.map.put(wrappedKey, value);
            return previous;
        }
        return this.map.put(Objects.requireNonNull(key), value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(this.keyWrap(key));
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.keyWrap(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es == null) {
            this.entrySet = new EntrySet();
            return this.entrySet;
        }
        return es;
    }

    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks == null) {
            this.keySet = new KeySet();
            return this.keySet;
        }
        return ks;
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return this.map.equals(obj);
    }

    public Map<K, V> asUnmodifiableMap() {
        return Collections.unmodifiableMap(this);
    }

    public Dictionary<K, V> asUnmodifiableDictionary() {
        return CaseInsensitiveDictionaryMap.unmodifiableDictionary(this);
    }

    public static <K, V> Dictionary<K, V> unmodifiableDictionary(Dictionary<? extends K, ? extends V> d) {
        return new UnmodifiableDictionary<K, V>(d);
    }

    private static final class CaseInsensitiveKey {
        final String key;
        private transient int hashCode;

        CaseInsensitiveKey(String key) {
            this.key = key;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h != 0) {
                return h;
            }
            h = 1;
            char[] cArray = this.key.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                h = 31 * h + Character.toLowerCase(Character.toUpperCase(c));
                ++n2;
            }
            this.hashCode = h;
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof CaseInsensitiveKey) {
                return this.key.equalsIgnoreCase(((CaseInsensitiveKey)obj).key);
            }
            return false;
        }

        public String toString() {
            return this.key;
        }
    }

    private static final class CaseInsentiveEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<Object, V> entry;

        CaseInsentiveEntry(Map.Entry<Object, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            Object k = this.entry.getKey();
            if (k instanceof CaseInsensitiveKey) {
                k = ((CaseInsensitiveKey)k).key;
            }
            return (K)k;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(Objects.requireNonNull(value));
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.entry.getKey()) ^ Objects.hashCode(this.entry.getValue());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof Map.Entry) {
                Object k2;
                Map.Entry other = (Map.Entry)obj;
                Object k1 = this.entry.getKey();
                Object object = k2 = other instanceof CaseInsentiveEntry ? ((CaseInsentiveEntry)other).entry.getKey() : other.getKey();
                return Objects.equals(k1, k2) && Objects.equals(this.entry.getValue(), other.getValue());
            }
            return false;
        }

        public String toString() {
            return this.entry.toString();
        }
    }

    private static final class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Object, V>> i;

        EntryIterator(Collection<Map.Entry<Object, V>> c) {
            this.i = c.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new CaseInsentiveEntry(this.i.next());
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public int size() {
            return CaseInsensitiveDictionaryMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveDictionaryMap.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(CaseInsensitiveDictionaryMap.this.map.entrySet());
        }

        @Override
        public void clear() {
            CaseInsensitiveDictionaryMap.this.clear();
        }
    }

    private static final class KeyIterator<K>
    implements Iterator<K> {
        private final Iterator<Object> i;

        KeyIterator(Collection<Object> c) {
            this.i = c.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public K next() {
            Object k = this.i.next();
            if (k instanceof CaseInsensitiveKey) {
                k = ((CaseInsensitiveKey)k).key;
            }
            return (K)k;
        }

        @Override
        public void remove() {
            this.i.remove();
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public int size() {
            return CaseInsensitiveDictionaryMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return CaseInsensitiveDictionaryMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return CaseInsensitiveDictionaryMap.this.containsKey(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator(CaseInsensitiveDictionaryMap.this.map.keySet());
        }

        @Override
        public boolean remove(Object o) {
            return CaseInsensitiveDictionaryMap.this.remove(o) != null;
        }

        @Override
        public void clear() {
            CaseInsensitiveDictionaryMap.this.clear();
        }
    }

    private static final class UnmodifiableDictionary<K, V>
    extends Dictionary<K, V> {
        private final Dictionary<? extends K, ? extends V> d;

        UnmodifiableDictionary(Dictionary<? extends K, ? extends V> d) {
            this.d = Objects.requireNonNull(d);
        }

        @Override
        public int size() {
            return this.d.size();
        }

        @Override
        public boolean isEmpty() {
            return this.d.isEmpty();
        }

        @Override
        public Enumeration<K> keys() {
            return this.d.keys();
        }

        @Override
        public Enumeration<V> elements() {
            return this.d.elements();
        }

        @Override
        public V get(Object key) {
            return this.d.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.d.toString();
        }

        public int hashCode() {
            return this.d.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return this.d.equals(obj);
        }
    }
}

